/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationResourceLifecycleConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(ApplicationResourceLifecycleConfig.getter(ApplicationResourceLifecycleConfig::serviceRole)).setter(ApplicationResourceLifecycleConfig.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<ApplicationVersionLifecycleConfig> VERSION_LIFECYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VersionLifecycleConfig").getter(ApplicationResourceLifecycleConfig.getter(ApplicationResourceLifecycleConfig::versionLifecycleConfig)).setter(ApplicationResourceLifecycleConfig.setter(Builder::versionLifecycleConfig)).constructor(ApplicationVersionLifecycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLifecycleConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ROLE_FIELD, VERSION_LIFECYCLE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationResourceLifecycleConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceRole;
    private final ApplicationVersionLifecycleConfig versionLifecycleConfig;

    private ApplicationResourceLifecycleConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.versionLifecycleConfig = builder.versionLifecycleConfig;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final ApplicationVersionLifecycleConfig versionLifecycleConfig() {
        return this.versionLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLifecycleConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationResourceLifecycleConfig)) {
            return false;
        }
        ApplicationResourceLifecycleConfig other = (ApplicationResourceLifecycleConfig)obj;
        return Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.versionLifecycleConfig(), other.versionLifecycleConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationResourceLifecycleConfig").add("ServiceRole", (Object)this.serviceRole()).add("VersionLifecycleConfig", (Object)this.versionLifecycleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "VersionLifecycleConfig": {
                return Optional.ofNullable(clazz.cast(this.versionLifecycleConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceRole", SERVICE_ROLE_FIELD);
        map.put("VersionLifecycleConfig", VERSION_LIFECYCLE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationResourceLifecycleConfig, T> g) {
        return obj -> g.apply((ApplicationResourceLifecycleConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceRole;
        private ApplicationVersionLifecycleConfig versionLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationResourceLifecycleConfig model) {
            this.serviceRole(model.serviceRole);
            this.versionLifecycleConfig(model.versionLifecycleConfig);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final ApplicationVersionLifecycleConfig.Builder getVersionLifecycleConfig() {
            return this.versionLifecycleConfig != null ? this.versionLifecycleConfig.toBuilder() : null;
        }

        public final void setVersionLifecycleConfig(ApplicationVersionLifecycleConfig.BuilderImpl versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig != null ? versionLifecycleConfig.build() : null;
        }

        @Override
        public final Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig;
            return this;
        }

        public ApplicationResourceLifecycleConfig build() {
            return new ApplicationResourceLifecycleConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
        public Builder serviceRole(String var1);

        public Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig var1);

        default public Builder versionLifecycleConfig(Consumer<ApplicationVersionLifecycleConfig.Builder> versionLifecycleConfig) {
            return this.versionLifecycleConfig((ApplicationVersionLifecycleConfig)((ApplicationVersionLifecycleConfig.Builder)ApplicationVersionLifecycleConfig.builder().applyMutation(versionLifecycleConfig)).build());
        }
    }
}

