/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyState;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyStateChangeReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingPolicyStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingPolicyStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AutoScalingPolicyStatus.getter(AutoScalingPolicyStatus::stateAsString)).setter(AutoScalingPolicyStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<AutoScalingPolicyStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateChangeReason").getter(AutoScalingPolicyStatus.getter(AutoScalingPolicyStatus::stateChangeReason)).setter(AutoScalingPolicyStatus.setter(Builder::stateChangeReason)).constructor(AutoScalingPolicyStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, STATE_CHANGE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingPolicyStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final AutoScalingPolicyStateChangeReason stateChangeReason;

    private AutoScalingPolicyStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
    }

    public final AutoScalingPolicyState state() {
        return AutoScalingPolicyState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final AutoScalingPolicyStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingPolicyStatus)) {
            return false;
        }
        AutoScalingPolicyStatus other = (AutoScalingPolicyStatus)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingPolicyStatus").add("State", (Object)this.stateAsString()).add("StateChangeReason", (Object)this.stateChangeReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("State", STATE_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingPolicyStatus, T> g) {
        return obj -> g.apply((AutoScalingPolicyStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private AutoScalingPolicyStateChangeReason stateChangeReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingPolicyStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoScalingPolicyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final AutoScalingPolicyStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(AutoScalingPolicyStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(AutoScalingPolicyStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public AutoScalingPolicyStatus build() {
            return new AutoScalingPolicyStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingPolicyStatus> {
        public Builder state(String var1);

        public Builder state(AutoScalingPolicyState var1);

        public Builder stateChangeReason(AutoScalingPolicyStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<AutoScalingPolicyStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((AutoScalingPolicyStateChangeReason)((AutoScalingPolicyStateChangeReason.Builder)AutoScalingPolicyStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }
    }
}

