/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.ReplayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelReplayResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, CancelReplayResponse> {
    private static final SdkField<String> REPLAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayArn").getter(CancelReplayResponse.getter(CancelReplayResponse::replayArn)).setter(CancelReplayResponse.setter(Builder::replayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CancelReplayResponse.getter(CancelReplayResponse::stateAsString)).setter(CancelReplayResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(CancelReplayResponse.getter(CancelReplayResponse::stateReason)).setter(CancelReplayResponse.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_ARN_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelReplayResponse.memberNameToFieldInitializer();
    private final String replayArn;
    private final String state;
    private final String stateReason;

    private CancelReplayResponse(BuilderImpl builder) {
        super(builder);
        this.replayArn = builder.replayArn;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String replayArn() {
        return this.replayArn;
    }

    public final ReplayState state() {
        return ReplayState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReplayResponse)) {
            return false;
        }
        CancelReplayResponse other = (CancelReplayResponse)((Object)obj);
        return Objects.equals(this.replayArn(), other.replayArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"CancelReplayResponse").add("ReplayArn", (Object)this.replayArn()).add("State", (Object)this.stateAsString()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplayArn": {
                return Optional.ofNullable(clazz.cast(this.replayArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ReplayArn", REPLAY_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelReplayResponse, T> g) {
        return obj -> g.apply((CancelReplayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String replayArn;
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReplayResponse model) {
            super(model);
            this.replayArn(model.replayArn);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getReplayArn() {
            return this.replayArn;
        }

        public final void setReplayArn(String replayArn) {
            this.replayArn = replayArn;
        }

        @Override
        public final Builder replayArn(String replayArn) {
            this.replayArn = replayArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReplayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        @Override
        public CancelReplayResponse build() {
            return new CancelReplayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelReplayResponse> {
        public Builder replayArn(String var1);

        public Builder state(String var1);

        public Builder state(ReplayState var1);

        public Builder stateReason(String var1);
    }
}

