/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceBufferingHints;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceIndexRotationPeriod;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceRetryOptions;
import software.amazon.awssdk.services.firehose.model.AmazonopensearchserviceS3BackupMode;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.DocumentIdOptions;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.services.firehose.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmazonopensearchserviceDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmazonopensearchserviceDestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::roleARN)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainARN").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::domainARN)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::domainARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainARN").build()}).build();
    private static final SdkField<String> CLUSTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterEndpoint").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::clusterEndpoint)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::clusterEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::indexName)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::typeName)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> INDEX_ROTATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexRotationPeriod").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::indexRotationPeriodAsString)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::indexRotationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexRotationPeriod").build()}).build();
    private static final SdkField<AmazonopensearchserviceBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::bufferingHints)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::bufferingHints)).constructor(AmazonopensearchserviceBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<AmazonopensearchserviceRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::retryOptions)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::retryOptions)).constructor(AmazonopensearchserviceRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::s3BackupModeAsString)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::s3Configuration)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::processingConfiguration)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::cloudWatchLoggingOptions)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::vpcConfiguration)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<DocumentIdOptions> DOCUMENT_ID_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentIdOptions").getter(AmazonopensearchserviceDestinationConfiguration.getter(AmazonopensearchserviceDestinationConfiguration::documentIdOptions)).setter(AmazonopensearchserviceDestinationConfiguration.setter(Builder::documentIdOptions)).constructor(DocumentIdOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentIdOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DOMAIN_ARN_FIELD, CLUSTER_ENDPOINT_FIELD, INDEX_NAME_FIELD, TYPE_NAME_FIELD, INDEX_ROTATION_PERIOD_FIELD, BUFFERING_HINTS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD, DOCUMENT_ID_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AmazonopensearchserviceDestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String domainARN;
    private final String clusterEndpoint;
    private final String indexName;
    private final String typeName;
    private final String indexRotationPeriod;
    private final AmazonopensearchserviceBufferingHints bufferingHints;
    private final AmazonopensearchserviceRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3Configuration;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final VpcConfiguration vpcConfiguration;
    private final DocumentIdOptions documentIdOptions;

    private AmazonopensearchserviceDestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Configuration = builder.s3Configuration;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.documentIdOptions = builder.documentIdOptions;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String domainARN() {
        return this.domainARN;
    }

    public final String clusterEndpoint() {
        return this.clusterEndpoint;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod() {
        return AmazonopensearchserviceIndexRotationPeriod.fromValue(this.indexRotationPeriod);
    }

    public final String indexRotationPeriodAsString() {
        return this.indexRotationPeriod;
    }

    public final AmazonopensearchserviceBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final AmazonopensearchserviceRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final AmazonopensearchserviceS3BackupMode s3BackupMode() {
        return AmazonopensearchserviceS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final DocumentIdOptions documentIdOptions() {
        return this.documentIdOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonopensearchserviceDestinationConfiguration)) {
            return false;
        }
        AmazonopensearchserviceDestinationConfiguration other = (AmazonopensearchserviceDestinationConfiguration)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.domainARN(), other.domainARN()) && Objects.equals(this.clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.indexRotationPeriodAsString(), other.indexRotationPeriodAsString()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.documentIdOptions(), other.documentIdOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AmazonopensearchserviceDestinationConfiguration").add("RoleARN", (Object)this.roleARN()).add("DomainARN", (Object)this.domainARN()).add("ClusterEndpoint", (Object)this.clusterEndpoint()).add("IndexName", (Object)this.indexName()).add("TypeName", (Object)this.typeName()).add("IndexRotationPeriod", (Object)this.indexRotationPeriodAsString()).add("BufferingHints", (Object)this.bufferingHints()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("DocumentIdOptions", (Object)this.documentIdOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "DomainARN": {
                return Optional.ofNullable(clazz.cast(this.domainARN()));
            }
            case "ClusterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoint()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "IndexRotationPeriod": {
                return Optional.ofNullable(clazz.cast(this.indexRotationPeriodAsString()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "DocumentIdOptions": {
                return Optional.ofNullable(clazz.cast(this.documentIdOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("DomainARN", DOMAIN_ARN_FIELD);
        map.put("ClusterEndpoint", CLUSTER_ENDPOINT_FIELD);
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("IndexRotationPeriod", INDEX_ROTATION_PERIOD_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Configuration", S3_CONFIGURATION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("DocumentIdOptions", DOCUMENT_ID_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonopensearchserviceDestinationConfiguration, T> g) {
        return obj -> g.apply((AmazonopensearchserviceDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String domainARN;
        private String clusterEndpoint;
        private String indexName;
        private String typeName;
        private String indexRotationPeriod;
        private AmazonopensearchserviceBufferingHints bufferingHints;
        private AmazonopensearchserviceRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationConfiguration s3Configuration;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private VpcConfiguration vpcConfiguration;
        private DocumentIdOptions documentIdOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonopensearchserviceDestinationConfiguration model) {
            this.roleARN(model.roleARN);
            this.domainARN(model.domainARN);
            this.clusterEndpoint(model.clusterEndpoint);
            this.indexName(model.indexName);
            this.typeName(model.typeName);
            this.indexRotationPeriod(model.indexRotationPeriod);
            this.bufferingHints(model.bufferingHints);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Configuration(model.s3Configuration);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.vpcConfiguration(model.vpcConfiguration);
            this.documentIdOptions(model.documentIdOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getDomainARN() {
            return this.domainARN;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final String getClusterEndpoint() {
            return this.clusterEndpoint;
        }

        public final void setClusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
        }

        @Override
        public final Builder clusterEndpoint(String clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getIndexRotationPeriod() {
            return this.indexRotationPeriod;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod == null ? null : indexRotationPeriod.toString());
            return this;
        }

        public final AmazonopensearchserviceBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(AmazonopensearchserviceBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(AmazonopensearchserviceBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final AmazonopensearchserviceRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(AmazonopensearchserviceRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(AmazonopensearchserviceRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(AmazonopensearchserviceS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final DocumentIdOptions.Builder getDocumentIdOptions() {
            return this.documentIdOptions != null ? this.documentIdOptions.toBuilder() : null;
        }

        public final void setDocumentIdOptions(DocumentIdOptions.BuilderImpl documentIdOptions) {
            this.documentIdOptions = documentIdOptions != null ? documentIdOptions.build() : null;
        }

        @Override
        public final Builder documentIdOptions(DocumentIdOptions documentIdOptions) {
            this.documentIdOptions = documentIdOptions;
            return this;
        }

        public AmazonopensearchserviceDestinationConfiguration build() {
            return new AmazonopensearchserviceDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmazonopensearchserviceDestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder domainARN(String var1);

        public Builder clusterEndpoint(String var1);

        public Builder indexName(String var1);

        public Builder typeName(String var1);

        public Builder indexRotationPeriod(String var1);

        public Builder indexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod var1);

        public Builder bufferingHints(AmazonopensearchserviceBufferingHints var1);

        default public Builder bufferingHints(Consumer<AmazonopensearchserviceBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((AmazonopensearchserviceBufferingHints)((AmazonopensearchserviceBufferingHints.Builder)AmazonopensearchserviceBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder retryOptions(AmazonopensearchserviceRetryOptions var1);

        default public Builder retryOptions(Consumer<AmazonopensearchserviceRetryOptions.Builder> retryOptions) {
            return this.retryOptions((AmazonopensearchserviceRetryOptions)((AmazonopensearchserviceRetryOptions.Builder)AmazonopensearchserviceRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(AmazonopensearchserviceS3BackupMode var1);

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder documentIdOptions(DocumentIdOptions var1);

        default public Builder documentIdOptions(Consumer<DocumentIdOptions.Builder> documentIdOptions) {
            return this.documentIdOptions((DocumentIdOptions)((DocumentIdOptions.Builder)DocumentIdOptions.builder().applyMutation(documentIdOptions)).build());
        }
    }
}

