/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpEndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpEndpointConfiguration> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(HttpEndpointConfiguration.getter(HttpEndpointConfiguration::url)).setter(HttpEndpointConfiguration.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(HttpEndpointConfiguration.getter(HttpEndpointConfiguration::name)).setter(HttpEndpointConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKey").getter(HttpEndpointConfiguration.getter(HttpEndpointConfiguration::accessKey)).setter(HttpEndpointConfiguration.setter(Builder::accessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, NAME_FIELD, ACCESS_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HttpEndpointConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String name;
    private final String accessKey;

    private HttpEndpointConfiguration(BuilderImpl builder) {
        this.url = builder.url;
        this.name = builder.name;
        this.accessKey = builder.accessKey;
    }

    public final String url() {
        return this.url;
    }

    public final String name() {
        return this.name;
    }

    public final String accessKey() {
        return this.accessKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointConfiguration)) {
            return false;
        }
        HttpEndpointConfiguration other = (HttpEndpointConfiguration)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.accessKey(), other.accessKey());
    }

    public final String toString() {
        return ToString.builder((String)"HttpEndpointConfiguration").add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("AccessKey", (Object)(this.accessKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AccessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Url", URL_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AccessKey", ACCESS_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointConfiguration, T> g) {
        return obj -> g.apply((HttpEndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String name;
        private String accessKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointConfiguration model) {
            this.url(model.url);
            this.name(model.name);
            this.accessKey(model.accessKey);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAccessKey() {
            return this.accessKey;
        }

        public final void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        @Override
        public final Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public HttpEndpointConfiguration build() {
            return new HttpEndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpEndpointConfiguration> {
        public Builder url(String var1);

        public Builder name(String var1);

        public Builder accessKey(String var1);
    }
}

