/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartGeneratedCodeJobResponse extends GameSparksResponse implements
        ToCopyableBuilder<StartGeneratedCodeJobResponse.Builder, StartGeneratedCodeJobResponse> {
    private static final SdkField<String> GENERATED_CODE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedCodeJobId").getter(getter(StartGeneratedCodeJobResponse::generatedCodeJobId))
            .setter(setter(Builder::generatedCodeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJobId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_CODE_JOB_ID_FIELD));

    private final String generatedCodeJobId;

    private StartGeneratedCodeJobResponse(BuilderImpl builder) {
        super(builder);
        this.generatedCodeJobId = builder.generatedCodeJobId;
    }

    /**
     * <p>
     * The identifier of the code generation job. You can use this identifier in the <code>GetGeneratedCodeJob</code>
     * operation.
     * </p>
     * 
     * @return The identifier of the code generation job. You can use this identifier in the
     *         <code>GetGeneratedCodeJob</code> operation.
     */
    public final String generatedCodeJobId() {
        return generatedCodeJobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generatedCodeJobId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGeneratedCodeJobResponse)) {
            return false;
        }
        StartGeneratedCodeJobResponse other = (StartGeneratedCodeJobResponse) obj;
        return Objects.equals(generatedCodeJobId(), other.generatedCodeJobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartGeneratedCodeJobResponse").add("GeneratedCodeJobId", generatedCodeJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedCodeJobId":
            return Optional.ofNullable(clazz.cast(generatedCodeJobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartGeneratedCodeJobResponse, T> g) {
        return obj -> g.apply((StartGeneratedCodeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartGeneratedCodeJobResponse> {
        /**
         * <p>
         * The identifier of the code generation job. You can use this identifier in the
         * <code>GetGeneratedCodeJob</code> operation.
         * </p>
         * 
         * @param generatedCodeJobId
         *        The identifier of the code generation job. You can use this identifier in the
         *        <code>GetGeneratedCodeJob</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCodeJobId(String generatedCodeJobId);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private String generatedCodeJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGeneratedCodeJobResponse model) {
            super(model);
            generatedCodeJobId(model.generatedCodeJobId);
        }

        public final String getGeneratedCodeJobId() {
            return generatedCodeJobId;
        }

        public final void setGeneratedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
        }

        @Override
        public final Builder generatedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
            return this;
        }

        @Override
        public StartGeneratedCodeJobResponse build() {
            return new StartGeneratedCodeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
