/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartStageDeploymentResponse extends GameSparksResponse implements
        ToCopyableBuilder<StartStageDeploymentResponse.Builder, StartStageDeploymentResponse> {
    private static final SdkField<StageDeploymentDetails> STAGE_DEPLOYMENT_FIELD = SdkField
            .<StageDeploymentDetails> builder(MarshallingType.SDK_POJO).memberName("StageDeployment")
            .getter(getter(StartStageDeploymentResponse::stageDeployment)).setter(setter(Builder::stageDeployment))
            .constructor(StageDeploymentDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageDeployment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_DEPLOYMENT_FIELD));

    private final StageDeploymentDetails stageDeployment;

    private StartStageDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.stageDeployment = builder.stageDeployment;
    }

    /**
     * <p>
     * Properties that describe the stage deployment.
     * </p>
     * 
     * @return Properties that describe the stage deployment.
     */
    public final StageDeploymentDetails stageDeployment() {
        return stageDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stageDeployment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartStageDeploymentResponse)) {
            return false;
        }
        StartStageDeploymentResponse other = (StartStageDeploymentResponse) obj;
        return Objects.equals(stageDeployment(), other.stageDeployment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartStageDeploymentResponse").add("StageDeployment", stageDeployment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StageDeployment":
            return Optional.ofNullable(clazz.cast(stageDeployment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartStageDeploymentResponse, T> g) {
        return obj -> g.apply((StartStageDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartStageDeploymentResponse> {
        /**
         * <p>
         * Properties that describe the stage deployment.
         * </p>
         * 
         * @param stageDeployment
         *        Properties that describe the stage deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageDeployment(StageDeploymentDetails stageDeployment);

        /**
         * <p>
         * Properties that describe the stage deployment.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageDeploymentDetails.Builder} avoiding
         * the need to create one manually via {@link StageDeploymentDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageDeploymentDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #stageDeployment(StageDeploymentDetails)}.
         * 
         * @param stageDeployment
         *        a consumer that will call methods on {@link StageDeploymentDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stageDeployment(StageDeploymentDetails)
         */
        default Builder stageDeployment(Consumer<StageDeploymentDetails.Builder> stageDeployment) {
            return stageDeployment(StageDeploymentDetails.builder().applyMutation(stageDeployment).build());
        }
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private StageDeploymentDetails stageDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(StartStageDeploymentResponse model) {
            super(model);
            stageDeployment(model.stageDeployment);
        }

        public final StageDeploymentDetails.Builder getStageDeployment() {
            return stageDeployment != null ? stageDeployment.toBuilder() : null;
        }

        public final void setStageDeployment(StageDeploymentDetails.BuilderImpl stageDeployment) {
            this.stageDeployment = stageDeployment != null ? stageDeployment.build() : null;
        }

        @Override
        public final Builder stageDeployment(StageDeploymentDetails stageDeployment) {
            this.stageDeployment = stageDeployment;
            return this;
        }

        @Override
        public StartStageDeploymentResponse build() {
            return new StartStageDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
