/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.StatisticModelResult;
import software.amazon.awssdk.services.glue.model.StatisticModelResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityModelResultResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataQualityModelResultResponse> {
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedOn").getter(GetDataQualityModelResultResponse.getter(GetDataQualityModelResultResponse::completedOn)).setter(GetDataQualityModelResultResponse.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()}).build();
    private static final SdkField<List<StatisticModelResult>> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Model").getter(GetDataQualityModelResultResponse.getter(GetDataQualityModelResultResponse::model)).setter(GetDataQualityModelResultResponse.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatisticModelResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_ON_FIELD, MODEL_FIELD));
    private final Instant completedOn;
    private final List<StatisticModelResult> model;

    private GetDataQualityModelResultResponse(BuilderImpl builder) {
        super(builder);
        this.completedOn = builder.completedOn;
        this.model = builder.model;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final boolean hasModel() {
        return this.model != null && !(this.model instanceof SdkAutoConstructList);
    }

    public final List<StatisticModelResult> model() {
        return this.model;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModel() ? this.model() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityModelResultResponse)) {
            return false;
        }
        GetDataQualityModelResultResponse other = (GetDataQualityModelResultResponse)((Object)obj);
        return Objects.equals(this.completedOn(), other.completedOn()) && this.hasModel() == other.hasModel() && Objects.equals(this.model(), other.model());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityModelResultResponse").add("CompletedOn", (Object)this.completedOn()).add("Model", this.hasModel() ? this.model() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompletedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityModelResultResponse, T> g) {
        return obj -> g.apply((GetDataQualityModelResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private Instant completedOn;
        private List<StatisticModelResult> model = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityModelResultResponse model) {
            super(model);
            this.completedOn(model.completedOn);
            this.model(model.model);
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final List<StatisticModelResult.Builder> getModel() {
            List<StatisticModelResult.Builder> result = StatisticModelResultsCopier.copyToBuilder(this.model);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModel(Collection<StatisticModelResult.BuilderImpl> model) {
            this.model = StatisticModelResultsCopier.copyFromBuilder(model);
        }

        @Override
        public final Builder model(Collection<StatisticModelResult> model) {
            this.model = StatisticModelResultsCopier.copy(model);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder model(StatisticModelResult ... model) {
            this.model(Arrays.asList(model));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder model(Consumer<StatisticModelResult.Builder> ... model) {
            this.model(Stream.of(model).map(c -> (StatisticModelResult)((StatisticModelResult.Builder)StatisticModelResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDataQualityModelResultResponse build() {
            return new GetDataQualityModelResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityModelResultResponse> {
        public Builder completedOn(Instant var1);

        public Builder model(Collection<StatisticModelResult> var1);

        public Builder model(StatisticModelResult ... var1);

        public Builder model(Consumer<StatisticModelResult.Builder> ... var1);
    }
}

