/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.CustomPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Entity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Entity> {
    private static final SdkField<String> ENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityName").getter(Entity.getter(Entity::entityName)).setter(Entity.setter(Builder::entityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityName").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Entity.getter(Entity::label)).setter(Entity.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Boolean> IS_PARENT_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsParentEntity").getter(Entity.getter(Entity::isParentEntity)).setter(Entity.setter(Builder::isParentEntity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParentEntity").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Entity.getter(Entity::description)).setter(Entity.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(Entity.getter(Entity::category)).setter(Entity.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomProperties").getter(Entity.getter(Entity::customProperties)).setter(Entity.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_NAME_FIELD, LABEL_FIELD, IS_PARENT_ENTITY_FIELD, DESCRIPTION_FIELD, CATEGORY_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Entity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entityName;
    private final String label;
    private final Boolean isParentEntity;
    private final String description;
    private final String category;
    private final Map<String, String> customProperties;

    private Entity(BuilderImpl builder) {
        this.entityName = builder.entityName;
        this.label = builder.label;
        this.isParentEntity = builder.isParentEntity;
        this.description = builder.description;
        this.category = builder.category;
        this.customProperties = builder.customProperties;
    }

    public final String entityName() {
        return this.entityName;
    }

    public final String label() {
        return this.label;
    }

    public final Boolean isParentEntity() {
        return this.isParentEntity;
    }

    public final String description() {
        return this.description;
    }

    public final String category() {
        return this.category;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.isParentEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return Objects.equals(this.entityName(), other.entityName()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.isParentEntity(), other.isParentEntity()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.category(), other.category()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"Entity").add("EntityName", (Object)this.entityName()).add("Label", (Object)this.label()).add("IsParentEntity", (Object)this.isParentEntity()).add("Description", (Object)this.description()).add("Category", (Object)this.category()).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityName": {
                return Optional.ofNullable(clazz.cast(this.entityName()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "IsParentEntity": {
                return Optional.ofNullable(clazz.cast(this.isParentEntity()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "CustomProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EntityName", ENTITY_NAME_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("IsParentEntity", IS_PARENT_ENTITY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Entity, T> g) {
        return obj -> g.apply((Entity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entityName;
        private String label;
        private Boolean isParentEntity;
        private String description;
        private String category;
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Entity model) {
            this.entityName(model.entityName);
            this.label(model.label);
            this.isParentEntity(model.isParentEntity);
            this.description(model.description);
            this.category(model.category);
            this.customProperties(model.customProperties);
        }

        public final String getEntityName() {
            return this.entityName;
        }

        public final void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public final Builder entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getIsParentEntity() {
            return this.isParentEntity;
        }

        public final void setIsParentEntity(Boolean isParentEntity) {
            this.isParentEntity = isParentEntity;
        }

        @Override
        public final Builder isParentEntity(Boolean isParentEntity) {
            this.isParentEntity = isParentEntity;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        public Entity build() {
            return new Entity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Entity> {
        public Builder entityName(String var1);

        public Builder label(String var1);

        public Builder isParentEntity(Boolean var1);

        public Builder description(String var1);

        public Builder category(String var1);

        public Builder customProperties(Map<String, String> var1);
    }
}

