/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.DeploymentType;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.services.greengrass.model.ErrorDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BulkDeploymentResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BulkDeploymentResult> {
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(BulkDeploymentResult.getter(BulkDeploymentResult::createdAt)).setter(BulkDeploymentResult.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentArn").getter(BulkDeploymentResult.getter(BulkDeploymentResult::deploymentArn)).setter(BulkDeploymentResult.setter(Builder::deploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentArn").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(BulkDeploymentResult.getter(BulkDeploymentResult::deploymentId)).setter(BulkDeploymentResult.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(BulkDeploymentResult.getter(BulkDeploymentResult::deploymentStatus)).setter(BulkDeploymentResult.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentType").getter(BulkDeploymentResult.getter(BulkDeploymentResult::deploymentTypeAsString)).setter(BulkDeploymentResult.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentType").build()}).build();
    private static final SdkField<List<ErrorDetail>> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorDetails").getter(BulkDeploymentResult.getter(BulkDeploymentResult::errorDetails)).setter(BulkDeploymentResult.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(BulkDeploymentResult.getter(BulkDeploymentResult::errorMessage)).setter(BulkDeploymentResult.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupArn").getter(BulkDeploymentResult.getter(BulkDeploymentResult::groupArn)).setter(BulkDeploymentResult.setter(Builder::groupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DEPLOYMENT_ARN_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_TYPE_FIELD, ERROR_DETAILS_FIELD, ERROR_MESSAGE_FIELD, GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BulkDeploymentResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String createdAt;
    private final String deploymentArn;
    private final String deploymentId;
    private final String deploymentStatus;
    private final String deploymentType;
    private final List<ErrorDetail> errorDetails;
    private final String errorMessage;
    private final String groupArn;

    private BulkDeploymentResult(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.deploymentArn = builder.deploymentArn;
        this.deploymentId = builder.deploymentId;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentType = builder.deploymentType;
        this.errorDetails = builder.errorDetails;
        this.errorMessage = builder.errorMessage;
        this.groupArn = builder.groupArn;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String deploymentArn() {
        return this.deploymentArn;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final boolean hasErrorDetails() {
        return this.errorDetails != null && !(this.errorDetails instanceof SdkAutoConstructList);
    }

    public final List<ErrorDetail> errorDetails() {
        return this.errorDetails;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String groupArn() {
        return this.groupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorDetails() ? this.errorDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkDeploymentResult)) {
            return false;
        }
        BulkDeploymentResult other = (BulkDeploymentResult)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentArn(), other.deploymentArn()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && this.hasErrorDetails() == other.hasErrorDetails() && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.groupArn(), other.groupArn());
    }

    public final String toString() {
        return ToString.builder((String)"BulkDeploymentResult").add("CreatedAt", (Object)this.createdAt()).add("DeploymentArn", (Object)this.deploymentArn()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentStatus", (Object)this.deploymentStatus()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("ErrorDetails", this.hasErrorDetails() ? this.errorDetails() : null).add("ErrorMessage", (Object)this.errorMessage()).add("GroupArn", (Object)this.groupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DeploymentArn": {
                return Optional.ofNullable(clazz.cast(this.deploymentArn()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
            case "DeploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "GroupArn": {
                return Optional.ofNullable(clazz.cast(this.groupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DeploymentArn", DEPLOYMENT_ARN_FIELD);
        map.put("DeploymentId", DEPLOYMENT_ID_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("DeploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("GroupArn", GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BulkDeploymentResult, T> g) {
        return obj -> g.apply((BulkDeploymentResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String createdAt;
        private String deploymentArn;
        private String deploymentId;
        private String deploymentStatus;
        private String deploymentType;
        private List<ErrorDetail> errorDetails = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;
        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkDeploymentResult model) {
            this.createdAt(model.createdAt);
            this.deploymentArn(model.deploymentArn);
            this.deploymentId(model.deploymentId);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentType(model.deploymentType);
            this.errorDetails(model.errorDetails);
            this.errorMessage(model.errorMessage);
            this.groupArn(model.groupArn);
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDeploymentArn() {
            return this.deploymentArn;
        }

        public final void setDeploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
        }

        @Override
        public final Builder deploymentArn(String deploymentArn) {
            this.deploymentArn = deploymentArn;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final List<ErrorDetail.Builder> getErrorDetails() {
            List<ErrorDetail.Builder> result = ErrorDetailsCopier.copyToBuilder(this.errorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorDetails(Collection<ErrorDetail.BuilderImpl> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copyFromBuilder(errorDetails);
        }

        @Override
        public final Builder errorDetails(Collection<ErrorDetail> errorDetails) {
            this.errorDetails = ErrorDetailsCopier.copy(errorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(ErrorDetail ... errorDetails) {
            this.errorDetails(Arrays.asList(errorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorDetails(Consumer<ErrorDetail.Builder> ... errorDetails) {
            this.errorDetails(Stream.of(errorDetails).map(c -> (ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getGroupArn() {
            return this.groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public BulkDeploymentResult build() {
            return new BulkDeploymentResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BulkDeploymentResult> {
        public Builder createdAt(String var1);

        public Builder deploymentArn(String var1);

        public Builder deploymentId(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder errorDetails(Collection<ErrorDetail> var1);

        public Builder errorDetails(ErrorDetail ... var1);

        public Builder errorDetails(Consumer<ErrorDetail.Builder> ... var1);

        public Builder errorMessage(String var1);

        public Builder groupArn(String var1);
    }
}

