/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AssessmentRunState {
    CREATED("CREATED"),
    START_DATA_COLLECTION_PENDING("START_DATA_COLLECTION_PENDING"),
    START_DATA_COLLECTION_IN_PROGRESS("START_DATA_COLLECTION_IN_PROGRESS"),
    COLLECTING_DATA("COLLECTING_DATA"),
    STOP_DATA_COLLECTION_PENDING("STOP_DATA_COLLECTION_PENDING"),
    DATA_COLLECTED("DATA_COLLECTED"),
    START_EVALUATING_RULES_PENDING("START_EVALUATING_RULES_PENDING"),
    EVALUATING_RULES("EVALUATING_RULES"),
    FAILED("FAILED"),
    ERROR("ERROR"),
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ERRORS("COMPLETED_WITH_ERRORS"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AssessmentRunState> VALUE_MAP;
    private final String value;

    private AssessmentRunState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AssessmentRunState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AssessmentRunState> knownValues() {
        EnumSet<AssessmentRunState> knownValues = EnumSet.allOf(AssessmentRunState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AssessmentRunState.class, AssessmentRunState::toString);
    }
}

