/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.FailedItemErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedItemDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedItemDetails> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(FailedItemDetails.getter(FailedItemDetails::failureCodeAsString)).setter(FailedItemDetails.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<Boolean> RETRYABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("retryable").getter(FailedItemDetails.getter(FailedItemDetails::retryable)).setter(FailedItemDetails.setter(Builder::retryable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD, RETRYABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailedItemDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String failureCode;
    private final Boolean retryableValue;

    private FailedItemDetails(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.retryableValue = builder.retryableValue;
    }

    public final FailedItemErrorCode failureCode() {
        return FailedItemErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final Boolean retryable() {
        return this.retryableValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedItemDetails)) {
            return false;
        }
        FailedItemDetails other = (FailedItemDetails)obj;
        return Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.retryable(), other.retryable());
    }

    public final String toString() {
        return ToString.builder((String)"FailedItemDetails").add("FailureCode", (Object)this.failureCodeAsString()).add("Retryable", (Object)this.retryable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "retryable": {
                return Optional.ofNullable(clazz.cast(this.retryable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("retryable", RETRYABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedItemDetails, T> g) {
        return obj -> g.apply((FailedItemDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureCode;
        private Boolean retryableValue;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedItemDetails model) {
            this.failureCode(model.failureCode);
            this.retryable(model.retryableValue);
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailedItemErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Boolean getRetryable() {
            return this.retryableValue;
        }

        public final void setRetryable(Boolean retryableValue) {
            this.retryableValue = retryableValue;
        }

        @Override
        public final Builder retryable(Boolean retryableValue) {
            this.retryableValue = retryableValue;
            return this;
        }

        public FailedItemDetails build() {
            return new FailedItemDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedItemDetails> {
        public Builder failureCode(String var1);

        public Builder failureCode(FailedItemErrorCode var1);

        public Builder retryable(Boolean var1);
    }
}

