/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InspectorEvent {
    ASSESSMENT_RUN_STARTED("ASSESSMENT_RUN_STARTED"),
    ASSESSMENT_RUN_COMPLETED("ASSESSMENT_RUN_COMPLETED"),
    ASSESSMENT_RUN_STATE_CHANGED("ASSESSMENT_RUN_STATE_CHANGED"),
    FINDING_REPORTED("FINDING_REPORTED"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InspectorEvent> VALUE_MAP;
    private final String value;

    private InspectorEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InspectorEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InspectorEvent> knownValues() {
        EnumSet<InspectorEvent> knownValues = EnumSet.allOf(InspectorEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InspectorEvent.class, InspectorEvent::toString);
    }
}

