/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector.model.AgentPreview;
import software.amazon.awssdk.services.inspector.model.AgentPreviewListCopier;
import software.amazon.awssdk.services.inspector.model.InspectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreviewAgentsResponse
extends InspectorResponse
implements ToCopyableBuilder<Builder, PreviewAgentsResponse> {
    private static final SdkField<List<AgentPreview>> AGENT_PREVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentPreviews").getter(PreviewAgentsResponse.getter(PreviewAgentsResponse::agentPreviews)).setter(PreviewAgentsResponse.setter(Builder::agentPreviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentPreviews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentPreview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(PreviewAgentsResponse.getter(PreviewAgentsResponse::nextToken)).setter(PreviewAgentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PREVIEWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreviewAgentsResponse.memberNameToFieldInitializer();
    private final List<AgentPreview> agentPreviews;
    private final String nextToken;

    private PreviewAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agentPreviews = builder.agentPreviews;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAgentPreviews() {
        return this.agentPreviews != null && !(this.agentPreviews instanceof SdkAutoConstructList);
    }

    public final List<AgentPreview> agentPreviews() {
        return this.agentPreviews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentPreviews() ? this.agentPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewAgentsResponse)) {
            return false;
        }
        PreviewAgentsResponse other = (PreviewAgentsResponse)((Object)obj);
        return this.hasAgentPreviews() == other.hasAgentPreviews() && Objects.equals(this.agentPreviews(), other.agentPreviews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"PreviewAgentsResponse").add("AgentPreviews", this.hasAgentPreviews() ? this.agentPreviews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentPreviews": {
                return Optional.ofNullable(clazz.cast(this.agentPreviews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentPreviews", AGENT_PREVIEWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewAgentsResponse, T> g) {
        return obj -> g.apply((PreviewAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorResponse.BuilderImpl
    implements Builder {
        private List<AgentPreview> agentPreviews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewAgentsResponse model) {
            super(model);
            this.agentPreviews(model.agentPreviews);
            this.nextToken(model.nextToken);
        }

        public final List<AgentPreview.Builder> getAgentPreviews() {
            List<AgentPreview.Builder> result = AgentPreviewListCopier.copyToBuilder(this.agentPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentPreviews(Collection<AgentPreview.BuilderImpl> agentPreviews) {
            this.agentPreviews = AgentPreviewListCopier.copyFromBuilder(agentPreviews);
        }

        @Override
        public final Builder agentPreviews(Collection<AgentPreview> agentPreviews) {
            this.agentPreviews = AgentPreviewListCopier.copy(agentPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentPreviews(AgentPreview ... agentPreviews) {
            this.agentPreviews(Arrays.asList(agentPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentPreviews(Consumer<AgentPreview.Builder> ... agentPreviews) {
            this.agentPreviews(Stream.of(agentPreviews).map(c -> (AgentPreview)((AgentPreview.Builder)AgentPreview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public PreviewAgentsResponse build() {
            return new PreviewAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends InspectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PreviewAgentsResponse> {
        public Builder agentPreviews(Collection<AgentPreview> var1);

        public Builder agentPreviews(AgentPreview ... var1);

        public Builder agentPreviews(Consumer<AgentPreview.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

