/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.DeviceMapCopier;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevicesInPlacementResponse
extends Iot1ClickProjectsResponse
implements ToCopyableBuilder<Builder, GetDevicesInPlacementResponse> {
    private static final SdkField<Map<String, String>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("devices").getter(GetDevicesInPlacementResponse.getter(GetDevicesInPlacementResponse::devices)).setter(GetDevicesInPlacementResponse.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD));
    private final Map<String, String> devices;

    private GetDevicesInPlacementResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
    }

    public boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructMap);
    }

    public Map<String, String> devices() {
        return this.devices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicesInPlacementResponse)) {
            return false;
        }
        GetDevicesInPlacementResponse other = (GetDevicesInPlacementResponse)((Object)obj);
        return this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices());
    }

    public String toString() {
        return ToString.builder((String)"GetDevicesInPlacementResponse").add("Devices", this.hasDevices() ? this.devices() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicesInPlacementResponse, T> g) {
        return obj -> g.apply((GetDevicesInPlacementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickProjectsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> devices = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicesInPlacementResponse model) {
            super(model);
            this.devices(model.devices);
        }

        public final Map<String, String> getDevices() {
            if (this.devices instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.devices;
        }

        @Override
        public final Builder devices(Map<String, String> devices) {
            this.devices = DeviceMapCopier.copy(devices);
            return this;
        }

        public final void setDevices(Map<String, String> devices) {
            this.devices = DeviceMapCopier.copy(devices);
        }

        @Override
        public GetDevicesInPlacementResponse build() {
            return new GetDevicesInPlacementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickProjectsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevicesInPlacementResponse> {
        public Builder devices(Map<String, String> var1);
    }
}

