/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.BatchEntryCompletionStatus;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyAggregatesSkippedEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetAssetPropertyAggregatesSkippedEntry> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(BatchGetAssetPropertyAggregatesSkippedEntry.getter(BatchGetAssetPropertyAggregatesSkippedEntry::entryId)).setter(BatchGetAssetPropertyAggregatesSkippedEntry.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> COMPLETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("completionStatus").getter(BatchGetAssetPropertyAggregatesSkippedEntry.getter(BatchGetAssetPropertyAggregatesSkippedEntry::completionStatusAsString)).setter(BatchGetAssetPropertyAggregatesSkippedEntry.setter(Builder::completionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionStatus").build()}).build();
    private static final SdkField<BatchGetAssetPropertyAggregatesErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(BatchGetAssetPropertyAggregatesSkippedEntry.getter(BatchGetAssetPropertyAggregatesSkippedEntry::errorInfo)).setter(BatchGetAssetPropertyAggregatesSkippedEntry.setter(Builder::errorInfo)).constructor(BatchGetAssetPropertyAggregatesErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, COMPLETION_STATUS_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAssetPropertyAggregatesSkippedEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String completionStatus;
    private final BatchGetAssetPropertyAggregatesErrorInfo errorInfo;

    private BatchGetAssetPropertyAggregatesSkippedEntry(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.completionStatus = builder.completionStatus;
        this.errorInfo = builder.errorInfo;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final BatchEntryCompletionStatus completionStatus() {
        return BatchEntryCompletionStatus.fromValue(this.completionStatus);
    }

    public final String completionStatusAsString() {
        return this.completionStatus;
    }

    public final BatchGetAssetPropertyAggregatesErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesSkippedEntry)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesSkippedEntry other = (BatchGetAssetPropertyAggregatesSkippedEntry)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.completionStatusAsString(), other.completionStatusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyAggregatesSkippedEntry").add("EntryId", (Object)this.entryId()).add("CompletionStatus", (Object)this.completionStatusAsString()).add("ErrorInfo", (Object)this.errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "completionStatus": {
                return Optional.ofNullable(clazz.cast(this.completionStatusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryId", ENTRY_ID_FIELD);
        map.put("completionStatus", COMPLETION_STATUS_FIELD);
        map.put("errorInfo", ERROR_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesSkippedEntry, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesSkippedEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String completionStatus;
        private BatchGetAssetPropertyAggregatesErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesSkippedEntry model) {
            this.entryId(model.entryId);
            this.completionStatus(model.completionStatus);
            this.errorInfo(model.errorInfo);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final String getCompletionStatus() {
            return this.completionStatus;
        }

        public final void setCompletionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
        }

        @Override
        public final Builder completionStatus(String completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        @Override
        public final Builder completionStatus(BatchEntryCompletionStatus completionStatus) {
            this.completionStatus(completionStatus == null ? null : completionStatus.toString());
            return this;
        }

        public final BatchGetAssetPropertyAggregatesErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(BatchGetAssetPropertyAggregatesErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(BatchGetAssetPropertyAggregatesErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public BatchGetAssetPropertyAggregatesSkippedEntry build() {
            return new BatchGetAssetPropertyAggregatesSkippedEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesSkippedEntry> {
        public Builder entryId(String var1);

        public Builder completionStatus(String var1);

        public Builder completionStatus(BatchEntryCompletionStatus var1);

        public Builder errorInfo(BatchGetAssetPropertyAggregatesErrorInfo var1);

        default public Builder errorInfo(Consumer<BatchGetAssetPropertyAggregatesErrorInfo.Builder> errorInfo) {
            return this.errorInfo((BatchGetAssetPropertyAggregatesErrorInfo)((BatchGetAssetPropertyAggregatesErrorInfo.Builder)BatchGetAssetPropertyAggregatesErrorInfo.builder().applyMutation(errorInfo)).build());
        }
    }
}

