/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ActionSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.ActionSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListActionsResponse> {
    private static final SdkField<List<ActionSummary>> ACTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionSummaries").getter(ListActionsResponse.getter(ListActionsResponse::actionSummaries)).setter(ListActionsResponse.setter(Builder::actionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActionsResponse.getter(ListActionsResponse::nextToken)).setter(ListActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActionsResponse.memberNameToFieldInitializer();
    private final List<ActionSummary> actionSummaries;
    private final String nextToken;

    private ListActionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionSummaries = builder.actionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionSummaries() {
        return this.actionSummaries != null && !(this.actionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActionSummary> actionSummaries() {
        return this.actionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionSummaries() ? this.actionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionsResponse)) {
            return false;
        }
        ListActionsResponse other = (ListActionsResponse)((Object)obj);
        return this.hasActionSummaries() == other.hasActionSummaries() && Objects.equals(this.actionSummaries(), other.actionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActionsResponse").add("ActionSummaries", this.hasActionSummaries() ? this.actionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionSummaries": {
                return Optional.ofNullable(clazz.cast(this.actionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionSummaries", ACTION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionsResponse, T> g) {
        return obj -> g.apply((ListActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<ActionSummary> actionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionsResponse model) {
            super(model);
            this.actionSummaries(model.actionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ActionSummary.Builder> getActionSummaries() {
            List<ActionSummary.Builder> result = ActionSummariesCopier.copyToBuilder(this.actionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionSummaries(Collection<ActionSummary.BuilderImpl> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copyFromBuilder(actionSummaries);
        }

        @Override
        public final Builder actionSummaries(Collection<ActionSummary> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copy(actionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(ActionSummary ... actionSummaries) {
            this.actionSummaries(Arrays.asList(actionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(Consumer<ActionSummary.Builder> ... actionSummaries) {
            this.actionSummaries(Stream.of(actionSummaries).map(c -> (ActionSummary)((ActionSummary.Builder)ActionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActionsResponse build() {
            return new ListActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionsResponse> {
        public Builder actionSummaries(Collection<ActionSummary> var1);

        public Builder actionSummaries(ActionSummary ... var1);

        public Builder actionSummaries(Consumer<ActionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

