/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListTimeSeriesResponse;
import software.amazon.awssdk.services.iotsitewise.model.TimeSeriesSummary;

public class ListTimeSeriesIterable
implements SdkIterable<ListTimeSeriesResponse> {
    private final IoTSiteWiseClient client;
    private final ListTimeSeriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTimeSeriesIterable(IoTSiteWiseClient client, ListTimeSeriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTimeSeriesResponseFetcher();
    }

    public Iterator<ListTimeSeriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TimeSeriesSummary> timeSeriesSummaries() {
        Function<ListTimeSeriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.timeSeriesSummaries() != null) {
                return response.timeSeriesSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTimeSeriesResponseFetcher
    implements SyncPageFetcher<ListTimeSeriesResponse> {
        private ListTimeSeriesResponseFetcher() {
        }

        public boolean hasNextPage(ListTimeSeriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTimeSeriesResponse nextPage(ListTimeSeriesResponse previousPage) {
            if (previousPage == null) {
                return ListTimeSeriesIterable.this.client.listTimeSeries(ListTimeSeriesIterable.this.firstRequest);
            }
            return ListTimeSeriesIterable.this.client.listTimeSeries((ListTimeSeriesRequest)((Object)ListTimeSeriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

