/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ConflictingItem;
import software.amazon.awssdk.services.kendra.model.ConflictingItemsCopier;
import software.amazon.awssdk.services.kendra.model.KendraException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FeaturedResultsConflictException
extends KendraException
implements ToCopyableBuilder<Builder, FeaturedResultsConflictException> {
    private static final SdkField<List<ConflictingItem>> CONFLICTING_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConflictingItems").getter(FeaturedResultsConflictException.getter(FeaturedResultsConflictException::conflictingItems)).setter(FeaturedResultsConflictException.setter(Builder::conflictingItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConflictingItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICTING_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FeaturedResultsConflictException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ConflictingItem> conflictingItems;

    private FeaturedResultsConflictException(BuilderImpl builder) {
        super(builder);
        this.conflictingItems = builder.conflictingItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasConflictingItems() {
        return this.conflictingItems != null && !(this.conflictingItems instanceof SdkAutoConstructList);
    }

    public List<ConflictingItem> conflictingItems() {
        return this.conflictingItems;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ConflictingItem>>> map = new HashMap<String, SdkField<List<ConflictingItem>>>();
        map.put("ConflictingItems", CONFLICTING_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeaturedResultsConflictException, T> g) {
        return obj -> g.apply((FeaturedResultsConflictException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraException.BuilderImpl
    implements Builder {
        private List<ConflictingItem> conflictingItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FeaturedResultsConflictException model) {
            super(model);
            this.conflictingItems(model.conflictingItems);
        }

        public final List<ConflictingItem.Builder> getConflictingItems() {
            List<ConflictingItem.Builder> result = ConflictingItemsCopier.copyToBuilder(this.conflictingItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConflictingItems(Collection<ConflictingItem.BuilderImpl> conflictingItems) {
            this.conflictingItems = ConflictingItemsCopier.copyFromBuilder(conflictingItems);
        }

        @Override
        public final Builder conflictingItems(Collection<ConflictingItem> conflictingItems) {
            this.conflictingItems = ConflictingItemsCopier.copy(conflictingItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingItems(ConflictingItem ... conflictingItems) {
            this.conflictingItems(Arrays.asList(conflictingItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingItems(Consumer<ConflictingItem.Builder> ... conflictingItems) {
            this.conflictingItems(Stream.of(conflictingItems).map(c -> (ConflictingItem)((ConflictingItem.Builder)ConflictingItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public FeaturedResultsConflictException build() {
            return new FeaturedResultsConflictException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FeaturedResultsConflictException>,
    KendraException.Builder {
        public Builder conflictingItems(Collection<ConflictingItem> var1);

        public Builder conflictingItems(ConflictingItem ... var1);

        public Builder conflictingItems(Consumer<ConflictingItem.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

