/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.FsxFileSystemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FsxConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FsxConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(FsxConfiguration.getter(FsxConfiguration::fileSystemId)).setter(FsxConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<String> FILE_SYSTEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemType").getter(FsxConfiguration.getter(FsxConfiguration::fileSystemTypeAsString)).setter(FsxConfiguration.setter(Builder::fileSystemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemType").build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(FsxConfiguration.getter(FsxConfiguration::vpcConfiguration)).setter(FsxConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(FsxConfiguration.getter(FsxConfiguration::secretArn)).setter(FsxConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(FsxConfiguration.getter(FsxConfiguration::inclusionPatterns)).setter(FsxConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(FsxConfiguration.getter(FsxConfiguration::exclusionPatterns)).setter(FsxConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(FsxConfiguration.getter(FsxConfiguration::fieldMappings)).setter(FsxConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, FILE_SYSTEM_TYPE_FIELD, VPC_CONFIGURATION_FIELD, SECRET_ARN_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, FIELD_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FsxConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String fileSystemType;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final String secretArn;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private FsxConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.fileSystemType = builder.fileSystemType;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.secretArn = builder.secretArn;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.fieldMappings = builder.fieldMappings;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final FsxFileSystemType fileSystemType() {
        return FsxFileSystemType.fromValue(this.fileSystemType);
    }

    public final String fileSystemTypeAsString() {
        return this.fileSystemType;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxConfiguration)) {
            return false;
        }
        FsxConfiguration other = (FsxConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.fileSystemTypeAsString(), other.fileSystemTypeAsString()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.secretArn(), other.secretArn()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"FsxConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("FileSystemType", (Object)this.fileSystemTypeAsString()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("SecretArn", (Object)this.secretArn()).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "FileSystemType": {
                return Optional.ofNullable(clazz.cast(this.fileSystemTypeAsString()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("FileSystemType", FILE_SYSTEM_TYPE_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("InclusionPatterns", INCLUSION_PATTERNS_FIELD);
        map.put("ExclusionPatterns", EXCLUSION_PATTERNS_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FsxConfiguration, T> g) {
        return obj -> g.apply((FsxConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String fileSystemType;
        private DataSourceVpcConfiguration vpcConfiguration;
        private String secretArn;
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FsxConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.fileSystemType(model.fileSystemType);
            this.vpcConfiguration(model.vpcConfiguration);
            this.secretArn(model.secretArn);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.fieldMappings(model.fieldMappings);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getFileSystemType() {
            return this.fileSystemType;
        }

        public final void setFileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
        }

        @Override
        public final Builder fileSystemType(String fileSystemType) {
            this.fileSystemType = fileSystemType;
            return this;
        }

        @Override
        public final Builder fileSystemType(FsxFileSystemType fileSystemType) {
            this.fileSystemType(fileSystemType == null ? null : fileSystemType.toString());
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FsxConfiguration build() {
            return new FsxConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FsxConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder fileSystemType(String var1);

        public Builder fileSystemType(FsxFileSystemType var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder secretArn(String var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

