/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyGroup> {
    private static final SdkField<String> PROPERTY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyGroupId").getter(PropertyGroup.getter(PropertyGroup::propertyGroupId)).setter(PropertyGroup.setter(Builder::propertyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroupId").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTY_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PropertyMap").getter(PropertyGroup.getter(PropertyGroup::propertyMap)).setter(PropertyGroup.setter(Builder::propertyMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUP_ID_FIELD, PROPERTY_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String propertyGroupId;
    private final Map<String, String> propertyMap;

    private PropertyGroup(BuilderImpl builder) {
        this.propertyGroupId = builder.propertyGroupId;
        this.propertyMap = builder.propertyMap;
    }

    public final String propertyGroupId() {
        return this.propertyGroupId;
    }

    public final boolean hasPropertyMap() {
        return this.propertyMap != null && !(this.propertyMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> propertyMap() {
        return this.propertyMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyMap() ? this.propertyMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyGroup)) {
            return false;
        }
        PropertyGroup other = (PropertyGroup)obj;
        return Objects.equals(this.propertyGroupId(), other.propertyGroupId()) && this.hasPropertyMap() == other.hasPropertyMap() && Objects.equals(this.propertyMap(), other.propertyMap());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyGroup").add("PropertyGroupId", (Object)this.propertyGroupId()).add("PropertyMap", this.hasPropertyMap() ? this.propertyMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyGroupId": {
                return Optional.ofNullable(clazz.cast(this.propertyGroupId()));
            }
            case "PropertyMap": {
                return Optional.ofNullable(clazz.cast(this.propertyMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyGroup, T> g) {
        return obj -> g.apply((PropertyGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyGroupId;
        private Map<String, String> propertyMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyGroup model) {
            this.propertyGroupId(model.propertyGroupId);
            this.propertyMap(model.propertyMap);
        }

        public final String getPropertyGroupId() {
            return this.propertyGroupId;
        }

        public final void setPropertyGroupId(String propertyGroupId) {
            this.propertyGroupId = propertyGroupId;
        }

        @Override
        @Transient
        public final Builder propertyGroupId(String propertyGroupId) {
            this.propertyGroupId = propertyGroupId;
            return this;
        }

        public final Map<String, String> getPropertyMap() {
            if (this.propertyMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.propertyMap;
        }

        public final void setPropertyMap(Map<String, String> propertyMap) {
            this.propertyMap = PropertyMapCopier.copy(propertyMap);
        }

        @Override
        @Transient
        public final Builder propertyMap(Map<String, String> propertyMap) {
            this.propertyMap = PropertyMapCopier.copy(propertyMap);
            return this;
        }

        public PropertyGroup build() {
            return new PropertyGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyGroup> {
        public Builder propertyGroupId(String var1);

        public Builder propertyMap(Map<String, String> var1);
    }
}

