/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClient;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.MappedResourceConfigurationListItem;

public class DescribeMappedResourceConfigurationIterable
implements SdkIterable<DescribeMappedResourceConfigurationResponse> {
    private final KinesisVideoClient client;
    private final DescribeMappedResourceConfigurationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMappedResourceConfigurationIterable(KinesisVideoClient client, DescribeMappedResourceConfigurationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMappedResourceConfigurationResponseFetcher();
    }

    public Iterator<DescribeMappedResourceConfigurationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MappedResourceConfigurationListItem> mappedResourceConfigurationList() {
        Function<DescribeMappedResourceConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.mappedResourceConfigurationList() != null) {
                return response.mappedResourceConfigurationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMappedResourceConfigurationResponseFetcher
    implements SyncPageFetcher<DescribeMappedResourceConfigurationResponse> {
        private DescribeMappedResourceConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMappedResourceConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMappedResourceConfigurationResponse nextPage(DescribeMappedResourceConfigurationResponse previousPage) {
            if (previousPage == null) {
                return DescribeMappedResourceConfigurationIterable.this.client.describeMappedResourceConfiguration(DescribeMappedResourceConfigurationIterable.this.firstRequest);
            }
            return DescribeMappedResourceConfigurationIterable.this.client.describeMappedResourceConfiguration((DescribeMappedResourceConfigurationRequest)((Object)DescribeMappedResourceConfigurationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

