/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParametersForImportRequest extends KmsRequest implements
        ToCopyableBuilder<GetParametersForImportRequest.Builder, GetParametersForImportRequest> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetParametersForImportRequest::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> WRAPPING_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetParametersForImportRequest::wrappingAlgorithmAsString)).setter(setter(Builder::wrappingAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingAlgorithm").build()).build();

    private static final SdkField<String> WRAPPING_KEY_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetParametersForImportRequest::wrappingKeySpecAsString)).setter(setter(Builder::wrappingKeySpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeySpec").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD,
            WRAPPING_ALGORITHM_FIELD, WRAPPING_KEY_SPEC_FIELD));

    private final String keyId;

    private final String wrappingAlgorithm;

    private final String wrappingKeySpec;

    private GetParametersForImportRequest(BuilderImpl builder) {
        super(builder);
        this.keyId = builder.keyId;
        this.wrappingAlgorithm = builder.wrappingAlgorithm;
        this.wrappingKeySpec = builder.wrappingKeySpec;
    }

    /**
     * <p>
     * The identifier of the symmetric CMK into which you will import key material. The <code>Origin</code> of the CMK
     * must be <code>EXTERNAL</code>.
     * </p>
     * <p>
     * Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the key ID and key ARN for a CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     * 
     * @return The identifier of the symmetric CMK into which you will import key material. The <code>Origin</code> of
     *         the CMK must be <code>EXTERNAL</code>.</p>
     *         <p>
     *         Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To get the key ID and key ARN for a CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the
     * Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrappingAlgorithm}
     * will return {@link AlgorithmSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wrappingAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
     *         >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * @see AlgorithmSpec
     */
    public AlgorithmSpec wrappingAlgorithm() {
        return AlgorithmSpec.fromValue(wrappingAlgorithm);
    }

    /**
     * <p>
     * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt the
     * Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrappingAlgorithm}
     * will return {@link AlgorithmSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wrappingAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
     *         >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * @see AlgorithmSpec
     */
    public String wrappingAlgorithmAsString() {
        return wrappingAlgorithm;
    }

    /**
     * <p>
     * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrappingKeySpec}
     * will return {@link WrappingKeySpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wrappingKeySpecAsString}.
     * </p>
     * 
     * @return The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
     *         supported.
     * @see WrappingKeySpec
     */
    public WrappingKeySpec wrappingKeySpec() {
        return WrappingKeySpec.fromValue(wrappingKeySpec);
    }

    /**
     * <p>
     * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wrappingKeySpec}
     * will return {@link WrappingKeySpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wrappingKeySpecAsString}.
     * </p>
     * 
     * @return The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
     *         supported.
     * @see WrappingKeySpec
     */
    public String wrappingKeySpecAsString() {
        return wrappingKeySpec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wrappingKeySpecAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest) obj;
        return Objects.equals(keyId(), other.keyId())
                && Objects.equals(wrappingAlgorithmAsString(), other.wrappingAlgorithmAsString())
                && Objects.equals(wrappingKeySpecAsString(), other.wrappingKeySpecAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetParametersForImportRequest").add("KeyId", keyId())
                .add("WrappingAlgorithm", wrappingAlgorithmAsString()).add("WrappingKeySpec", wrappingKeySpecAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "WrappingAlgorithm":
            return Optional.ofNullable(clazz.cast(wrappingAlgorithmAsString()));
        case "WrappingKeySpec":
            return Optional.ofNullable(clazz.cast(wrappingKeySpecAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportRequest, T> g) {
        return obj -> g.apply((GetParametersForImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetParametersForImportRequest> {
        /**
         * <p>
         * The identifier of the symmetric CMK into which you will import key material. The <code>Origin</code> of the
         * CMK must be <code>EXTERNAL</code>.
         * </p>
         * <p>
         * Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
         * </p>
         * <p>
         * For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To get the key ID and key ARN for a CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
         * </p>
         * 
         * @param keyId
         *        The identifier of the symmetric CMK into which you will import key material. The <code>Origin</code>
         *        of the CMK must be <code>EXTERNAL</code>.</p>
         *        <p>
         *        Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To get the key ID and key ARN for a CMK, use <a>ListKeys</a> or <a>DescribeKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt
         * the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param wrappingAlgorithm
         *        The algorithm you will use to encrypt the key material before importing it with
         *        <a>ImportKeyMaterial</a>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
         *        >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see AlgorithmSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmSpec
         */
        Builder wrappingAlgorithm(String wrappingAlgorithm);

        /**
         * <p>
         * The algorithm you will use to encrypt the key material before importing it with <a>ImportKeyMaterial</a>. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html">Encrypt
         * the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param wrappingAlgorithm
         *        The algorithm you will use to encrypt the key material before importing it with
         *        <a>ImportKeyMaterial</a>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html"
         *        >Encrypt the Key Material</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * @see AlgorithmSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmSpec
         */
        Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm);

        /**
         * <p>
         * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
         * </p>
         * 
         * @param wrappingKeySpec
         *        The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
         *        supported.
         * @see WrappingKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappingKeySpec
         */
        Builder wrappingKeySpec(String wrappingKeySpec);

        /**
         * <p>
         * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
         * </p>
         * 
         * @param wrappingKeySpec
         *        The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are
         *        supported.
         * @see WrappingKeySpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WrappingKeySpec
         */
        Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KmsRequest.BuilderImpl implements Builder {
        private String keyId;

        private String wrappingAlgorithm;

        private String wrappingKeySpec;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            super(model);
            keyId(model.keyId);
            wrappingAlgorithm(model.wrappingAlgorithm);
            wrappingKeySpec(model.wrappingKeySpec);
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getWrappingAlgorithmAsString() {
            return wrappingAlgorithm;
        }

        @Override
        public final Builder wrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingAlgorithm(AlgorithmSpec wrappingAlgorithm) {
            this.wrappingAlgorithm(wrappingAlgorithm == null ? null : wrappingAlgorithm.toString());
            return this;
        }

        public final void setWrappingAlgorithm(String wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
        }

        public final String getWrappingKeySpecAsString() {
            return wrappingKeySpec;
        }

        @Override
        public final Builder wrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
            return this;
        }

        @Override
        public final Builder wrappingKeySpec(WrappingKeySpec wrappingKeySpec) {
            this.wrappingKeySpec(wrappingKeySpec == null ? null : wrappingKeySpec.toString());
            return this;
        }

        public final void setWrappingKeySpec(String wrappingKeySpec) {
            this.wrappingKeySpec = wrappingKeySpec;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
