/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomKeyStoreRequest extends KmsRequest implements
        ToCopyableBuilder<UpdateCustomKeyStoreRequest.Builder, UpdateCustomKeyStoreRequest> {
    private static final SdkField<String> CUSTOM_KEY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCustomKeyStoreRequest::customKeyStoreId)).setter(setter(Builder::customKeyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomKeyStoreId").build()).build();

    private static final SdkField<String> NEW_CUSTOM_KEY_STORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCustomKeyStoreRequest::newCustomKeyStoreName)).setter(setter(Builder::newCustomKeyStoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewCustomKeyStoreName").build())
            .build();

    private static final SdkField<String> KEY_STORE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCustomKeyStoreRequest::keyStorePassword)).setter(setter(Builder::keyStorePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorePassword").build()).build();

    private static final SdkField<String> CLOUD_HSM_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCustomKeyStoreRequest::cloudHsmClusterId)).setter(setter(Builder::cloudHsmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudHsmClusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_KEY_STORE_ID_FIELD,
            NEW_CUSTOM_KEY_STORE_NAME_FIELD, KEY_STORE_PASSWORD_FIELD, CLOUD_HSM_CLUSTER_ID_FIELD));

    private final String customKeyStoreId;

    private final String newCustomKeyStoreName;

    private final String keyStorePassword;

    private final String cloudHsmClusterId;

    private UpdateCustomKeyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.customKeyStoreId = builder.customKeyStoreId;
        this.newCustomKeyStoreName = builder.newCustomKeyStoreName;
        this.keyStorePassword = builder.keyStorePassword;
        this.cloudHsmClusterId = builder.cloudHsmClusterId;
    }

    /**
     * <p>
     * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of
     * a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
     * </p>
     * 
     * @return Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find
     *         the ID of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
     */
    public String customKeyStoreId() {
        return customKeyStoreId;
    }

    /**
     * <p>
     * Changes the friendly name of the custom key store to the value that you specify. The custom key store name must
     * be unique in the AWS account.
     * </p>
     * 
     * @return Changes the friendly name of the custom key store to the value that you specify. The custom key store
     *         name must be unique in the AWS account.
     */
    public String newCustomKeyStoreName() {
        return newCustomKeyStoreName;
    }

    /**
     * <p>
     * Enter the current password of the <code>kmsuser</code> crypto user (CU) in the AWS CloudHSM cluster that is
     * associated with the custom key store.
     * </p>
     * <p>
     * This parameter tells AWS KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set
     * or change the password of any users in the AWS CloudHSM cluster.
     * </p>
     * 
     * @return Enter the current password of the <code>kmsuser</code> crypto user (CU) in the AWS CloudHSM cluster that
     *         is associated with the custom key store.</p>
     *         <p>
     *         This parameter tells AWS KMS the current password of the <code>kmsuser</code> crypto user (CU). It does
     *         not set or change the password of any users in the AWS CloudHSM cluster.
     */
    public String keyStorePassword() {
        return keyStorePassword;
    }

    /**
     * <p>
     * Associates the custom key store with a related AWS CloudHSM cluster.
     * </p>
     * <p>
     * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a
     * backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to
     * associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the
     * requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster,
     * use the <a
     * href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a>
     * operation.
     * </p>
     * 
     * @return Associates the custom key store with a related AWS CloudHSM cluster. </p>
     *         <p>
     *         Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares
     *         a backup history and has the same cluster certificate as the original cluster. You cannot use this
     *         parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster
     *         must <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill
     *         the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of
     *         a cluster, use the <a
     *         href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html"
     *         >DescribeClusters</a> operation.
     */
    public String cloudHsmClusterId() {
        return cloudHsmClusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customKeyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(newCustomKeyStoreName());
        hashCode = 31 * hashCode + Objects.hashCode(keyStorePassword());
        hashCode = 31 * hashCode + Objects.hashCode(cloudHsmClusterId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomKeyStoreRequest)) {
            return false;
        }
        UpdateCustomKeyStoreRequest other = (UpdateCustomKeyStoreRequest) obj;
        return Objects.equals(customKeyStoreId(), other.customKeyStoreId())
                && Objects.equals(newCustomKeyStoreName(), other.newCustomKeyStoreName())
                && Objects.equals(keyStorePassword(), other.keyStorePassword())
                && Objects.equals(cloudHsmClusterId(), other.cloudHsmClusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCustomKeyStoreRequest").add("CustomKeyStoreId", customKeyStoreId())
                .add("NewCustomKeyStoreName", newCustomKeyStoreName())
                .add("KeyStorePassword", keyStorePassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CloudHsmClusterId", cloudHsmClusterId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomKeyStoreId":
            return Optional.ofNullable(clazz.cast(customKeyStoreId()));
        case "NewCustomKeyStoreName":
            return Optional.ofNullable(clazz.cast(newCustomKeyStoreName()));
        case "KeyStorePassword":
            return Optional.ofNullable(clazz.cast(keyStorePassword()));
        case "CloudHsmClusterId":
            return Optional.ofNullable(clazz.cast(cloudHsmClusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomKeyStoreRequest, T> g) {
        return obj -> g.apply((UpdateCustomKeyStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCustomKeyStoreRequest> {
        /**
         * <p>
         * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID
         * of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
         * </p>
         * 
         * @param customKeyStoreId
         *        Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find
         *        the ID of a custom key store, use the <a>DescribeCustomKeyStores</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customKeyStoreId(String customKeyStoreId);

        /**
         * <p>
         * Changes the friendly name of the custom key store to the value that you specify. The custom key store name
         * must be unique in the AWS account.
         * </p>
         * 
         * @param newCustomKeyStoreName
         *        Changes the friendly name of the custom key store to the value that you specify. The custom key store
         *        name must be unique in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newCustomKeyStoreName(String newCustomKeyStoreName);

        /**
         * <p>
         * Enter the current password of the <code>kmsuser</code> crypto user (CU) in the AWS CloudHSM cluster that is
         * associated with the custom key store.
         * </p>
         * <p>
         * This parameter tells AWS KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not
         * set or change the password of any users in the AWS CloudHSM cluster.
         * </p>
         * 
         * @param keyStorePassword
         *        Enter the current password of the <code>kmsuser</code> crypto user (CU) in the AWS CloudHSM cluster
         *        that is associated with the custom key store.</p>
         *        <p>
         *        This parameter tells AWS KMS the current password of the <code>kmsuser</code> crypto user (CU). It
         *        does not set or change the password of any users in the AWS CloudHSM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyStorePassword(String keyStorePassword);

        /**
         * <p>
         * Associates the custom key store with a related AWS CloudHSM cluster.
         * </p>
         * <p>
         * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a
         * backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to
         * associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the
         * requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a
         * cluster, use the <a
         * href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">
         * DescribeClusters</a> operation.
         * </p>
         * 
         * @param cloudHsmClusterId
         *        Associates the custom key store with a related AWS CloudHSM cluster. </p>
         *        <p>
         *        Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that
         *        shares a backup history and has the same cluster certificate as the original cluster. You cannot use
         *        this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement
         *        cluster must <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore"
         *        >fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster
         *        certificate of a cluster, use the <a
         *        href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html"
         *        >DescribeClusters</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudHsmClusterId(String cloudHsmClusterId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KmsRequest.BuilderImpl implements Builder {
        private String customKeyStoreId;

        private String newCustomKeyStoreName;

        private String keyStorePassword;

        private String cloudHsmClusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomKeyStoreRequest model) {
            super(model);
            customKeyStoreId(model.customKeyStoreId);
            newCustomKeyStoreName(model.newCustomKeyStoreName);
            keyStorePassword(model.keyStorePassword);
            cloudHsmClusterId(model.cloudHsmClusterId);
        }

        public final String getCustomKeyStoreId() {
            return customKeyStoreId;
        }

        @Override
        public final Builder customKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
            return this;
        }

        public final void setCustomKeyStoreId(String customKeyStoreId) {
            this.customKeyStoreId = customKeyStoreId;
        }

        public final String getNewCustomKeyStoreName() {
            return newCustomKeyStoreName;
        }

        @Override
        public final Builder newCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
            return this;
        }

        public final void setNewCustomKeyStoreName(String newCustomKeyStoreName) {
            this.newCustomKeyStoreName = newCustomKeyStoreName;
        }

        public final String getKeyStorePassword() {
            return keyStorePassword;
        }

        @Override
        public final Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public final void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public final String getCloudHsmClusterId() {
            return cloudHsmClusterId;
        }

        @Override
        public final Builder cloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
            return this;
        }

        public final void setCloudHsmClusterId(String cloudHsmClusterId) {
            this.cloudHsmClusterId = cloudHsmClusterId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomKeyStoreRequest build() {
            return new UpdateCustomKeyStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
