/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;

public class ListFunctionEventInvokeConfigsIterable
implements SdkIterable<ListFunctionEventInvokeConfigsResponse> {
    private final LambdaClient client;
    private final ListFunctionEventInvokeConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFunctionEventInvokeConfigsIterable(LambdaClient client, ListFunctionEventInvokeConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFunctionEventInvokeConfigsResponseFetcher();
    }

    public Iterator<ListFunctionEventInvokeConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionEventInvokeConfig> functionEventInvokeConfigs() {
        Function<ListFunctionEventInvokeConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionEventInvokeConfigs() != null) {
                return response.functionEventInvokeConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFunctionEventInvokeConfigsResponseFetcher
    implements SyncPageFetcher<ListFunctionEventInvokeConfigsResponse> {
        private ListFunctionEventInvokeConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionEventInvokeConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListFunctionEventInvokeConfigsResponse nextPage(ListFunctionEventInvokeConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionEventInvokeConfigsIterable.this.client.listFunctionEventInvokeConfigs(ListFunctionEventInvokeConfigsIterable.this.firstRequest);
            }
            return ListFunctionEventInvokeConfigsIterable.this.client.listFunctionEventInvokeConfigs((ListFunctionEventInvokeConfigsRequest)((Object)ListFunctionEventInvokeConfigsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

