/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.DialogAction;
import software.amazon.awssdk.services.lexmodelsv2.model.IntentOverride;
import software.amazon.awssdk.services.lexmodelsv2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DialogState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DialogState> {
    private static final SdkField<DialogAction> DIALOG_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dialogAction").getter(DialogState.getter(DialogState::dialogAction)).setter(DialogState.setter(Builder::dialogAction)).constructor(DialogAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogAction").build()}).build();
    private static final SdkField<IntentOverride> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intent").getter(DialogState.getter(DialogState::intent)).setter(DialogState.setter(Builder::intent)).constructor(IntentOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()}).build();
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sessionAttributes").getter(DialogState.getter(DialogState::sessionAttributes)).setter(DialogState.setter(Builder::sessionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALOG_ACTION_FIELD, INTENT_FIELD, SESSION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DialogState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DialogAction dialogAction;
    private final IntentOverride intent;
    private final Map<String, String> sessionAttributes;

    private DialogState(BuilderImpl builder) {
        this.dialogAction = builder.dialogAction;
        this.intent = builder.intent;
        this.sessionAttributes = builder.sessionAttributes;
    }

    public final DialogAction dialogAction() {
        return this.dialogAction;
    }

    public final IntentOverride intent() {
        return this.intent;
    }

    public final boolean hasSessionAttributes() {
        return this.sessionAttributes != null && !(this.sessionAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sessionAttributes() {
        return this.sessionAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.intent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionAttributes() ? this.sessionAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogState)) {
            return false;
        }
        DialogState other = (DialogState)obj;
        return Objects.equals(this.dialogAction(), other.dialogAction()) && Objects.equals(this.intent(), other.intent()) && this.hasSessionAttributes() == other.hasSessionAttributes() && Objects.equals(this.sessionAttributes(), other.sessionAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DialogState").add("DialogAction", (Object)this.dialogAction()).add("Intent", (Object)this.intent()).add("SessionAttributes", this.hasSessionAttributes() ? this.sessionAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dialogAction": {
                return Optional.ofNullable(clazz.cast(this.dialogAction()));
            }
            case "intent": {
                return Optional.ofNullable(clazz.cast(this.intent()));
            }
            case "sessionAttributes": {
                return Optional.ofNullable(clazz.cast(this.sessionAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dialogAction", DIALOG_ACTION_FIELD);
        map.put("intent", INTENT_FIELD);
        map.put("sessionAttributes", SESSION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DialogState, T> g) {
        return obj -> g.apply((DialogState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DialogAction dialogAction;
        private IntentOverride intent;
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DialogState model) {
            this.dialogAction(model.dialogAction);
            this.intent(model.intent);
            this.sessionAttributes(model.sessionAttributes);
        }

        public final DialogAction.Builder getDialogAction() {
            return this.dialogAction != null ? this.dialogAction.toBuilder() : null;
        }

        public final void setDialogAction(DialogAction.BuilderImpl dialogAction) {
            this.dialogAction = dialogAction != null ? dialogAction.build() : null;
        }

        @Override
        public final Builder dialogAction(DialogAction dialogAction) {
            this.dialogAction = dialogAction;
            return this;
        }

        public final IntentOverride.Builder getIntent() {
            return this.intent != null ? this.intent.toBuilder() : null;
        }

        public final void setIntent(IntentOverride.BuilderImpl intent) {
            this.intent = intent != null ? intent.build() : null;
        }

        @Override
        public final Builder intent(IntentOverride intent) {
            this.intent = intent;
            return this;
        }

        public final Map<String, String> getSessionAttributes() {
            if (this.sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public DialogState build() {
            return new DialogState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DialogState> {
        public Builder dialogAction(DialogAction var1);

        default public Builder dialogAction(Consumer<DialogAction.Builder> dialogAction) {
            return this.dialogAction((DialogAction)((DialogAction.Builder)DialogAction.builder().applyMutation(dialogAction)).build());
        }

        public Builder intent(IntentOverride var1);

        default public Builder intent(Consumer<IntentOverride.Builder> intent) {
            return this.intent((IntentOverride)((IntentOverride.Builder)IntentOverride.builder().applyMutation(intent)).build());
        }

        public Builder sessionAttributes(Map<String, String> var1);
    }
}

