/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyImportSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetImportResourceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportResourceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportResourceSpecification> {
    private static final SdkField<BotImportSpecification> BOT_IMPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("botImportSpecification").getter(ImportResourceSpecification.getter(ImportResourceSpecification::botImportSpecification)).setter(ImportResourceSpecification.setter(Builder::botImportSpecification)).constructor(BotImportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botImportSpecification").build()}).build();
    private static final SdkField<BotLocaleImportSpecification> BOT_LOCALE_IMPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("botLocaleImportSpecification").getter(ImportResourceSpecification.getter(ImportResourceSpecification::botLocaleImportSpecification)).setter(ImportResourceSpecification.setter(Builder::botLocaleImportSpecification)).constructor(BotLocaleImportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleImportSpecification").build()}).build();
    private static final SdkField<CustomVocabularyImportSpecification> CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customVocabularyImportSpecification").getter(ImportResourceSpecification.getter(ImportResourceSpecification::customVocabularyImportSpecification)).setter(ImportResourceSpecification.setter(Builder::customVocabularyImportSpecification)).constructor(CustomVocabularyImportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customVocabularyImportSpecification").build()}).build();
    private static final SdkField<TestSetImportResourceSpecification> TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testSetImportResourceSpecification").getter(ImportResourceSpecification.getter(ImportResourceSpecification::testSetImportResourceSpecification)).setter(ImportResourceSpecification.setter(Builder::testSetImportResourceSpecification)).constructor(TestSetImportResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetImportResourceSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_IMPORT_SPECIFICATION_FIELD, BOT_LOCALE_IMPORT_SPECIFICATION_FIELD, CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD, TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportResourceSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BotImportSpecification botImportSpecification;
    private final BotLocaleImportSpecification botLocaleImportSpecification;
    private final CustomVocabularyImportSpecification customVocabularyImportSpecification;
    private final TestSetImportResourceSpecification testSetImportResourceSpecification;

    private ImportResourceSpecification(BuilderImpl builder) {
        this.botImportSpecification = builder.botImportSpecification;
        this.botLocaleImportSpecification = builder.botLocaleImportSpecification;
        this.customVocabularyImportSpecification = builder.customVocabularyImportSpecification;
        this.testSetImportResourceSpecification = builder.testSetImportResourceSpecification;
    }

    public final BotImportSpecification botImportSpecification() {
        return this.botImportSpecification;
    }

    public final BotLocaleImportSpecification botLocaleImportSpecification() {
        return this.botLocaleImportSpecification;
    }

    public final CustomVocabularyImportSpecification customVocabularyImportSpecification() {
        return this.customVocabularyImportSpecification;
    }

    public final TestSetImportResourceSpecification testSetImportResourceSpecification() {
        return this.testSetImportResourceSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customVocabularyImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetImportResourceSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourceSpecification)) {
            return false;
        }
        ImportResourceSpecification other = (ImportResourceSpecification)obj;
        return Objects.equals(this.botImportSpecification(), other.botImportSpecification()) && Objects.equals(this.botLocaleImportSpecification(), other.botLocaleImportSpecification()) && Objects.equals(this.customVocabularyImportSpecification(), other.customVocabularyImportSpecification()) && Objects.equals(this.testSetImportResourceSpecification(), other.testSetImportResourceSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ImportResourceSpecification").add("BotImportSpecification", (Object)this.botImportSpecification()).add("BotLocaleImportSpecification", (Object)this.botLocaleImportSpecification()).add("CustomVocabularyImportSpecification", (Object)this.customVocabularyImportSpecification()).add("TestSetImportResourceSpecification", (Object)this.testSetImportResourceSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botImportSpecification": {
                return Optional.ofNullable(clazz.cast(this.botImportSpecification()));
            }
            case "botLocaleImportSpecification": {
                return Optional.ofNullable(clazz.cast(this.botLocaleImportSpecification()));
            }
            case "customVocabularyImportSpecification": {
                return Optional.ofNullable(clazz.cast(this.customVocabularyImportSpecification()));
            }
            case "testSetImportResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.testSetImportResourceSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botImportSpecification", BOT_IMPORT_SPECIFICATION_FIELD);
        map.put("botLocaleImportSpecification", BOT_LOCALE_IMPORT_SPECIFICATION_FIELD);
        map.put("customVocabularyImportSpecification", CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD);
        map.put("testSetImportResourceSpecification", TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportResourceSpecification, T> g) {
        return obj -> g.apply((ImportResourceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BotImportSpecification botImportSpecification;
        private BotLocaleImportSpecification botLocaleImportSpecification;
        private CustomVocabularyImportSpecification customVocabularyImportSpecification;
        private TestSetImportResourceSpecification testSetImportResourceSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourceSpecification model) {
            this.botImportSpecification(model.botImportSpecification);
            this.botLocaleImportSpecification(model.botLocaleImportSpecification);
            this.customVocabularyImportSpecification(model.customVocabularyImportSpecification);
            this.testSetImportResourceSpecification(model.testSetImportResourceSpecification);
        }

        public final BotImportSpecification.Builder getBotImportSpecification() {
            return this.botImportSpecification != null ? this.botImportSpecification.toBuilder() : null;
        }

        public final void setBotImportSpecification(BotImportSpecification.BuilderImpl botImportSpecification) {
            this.botImportSpecification = botImportSpecification != null ? botImportSpecification.build() : null;
        }

        @Override
        public final Builder botImportSpecification(BotImportSpecification botImportSpecification) {
            this.botImportSpecification = botImportSpecification;
            return this;
        }

        public final BotLocaleImportSpecification.Builder getBotLocaleImportSpecification() {
            return this.botLocaleImportSpecification != null ? this.botLocaleImportSpecification.toBuilder() : null;
        }

        public final void setBotLocaleImportSpecification(BotLocaleImportSpecification.BuilderImpl botLocaleImportSpecification) {
            this.botLocaleImportSpecification = botLocaleImportSpecification != null ? botLocaleImportSpecification.build() : null;
        }

        @Override
        public final Builder botLocaleImportSpecification(BotLocaleImportSpecification botLocaleImportSpecification) {
            this.botLocaleImportSpecification = botLocaleImportSpecification;
            return this;
        }

        public final CustomVocabularyImportSpecification.Builder getCustomVocabularyImportSpecification() {
            return this.customVocabularyImportSpecification != null ? this.customVocabularyImportSpecification.toBuilder() : null;
        }

        public final void setCustomVocabularyImportSpecification(CustomVocabularyImportSpecification.BuilderImpl customVocabularyImportSpecification) {
            this.customVocabularyImportSpecification = customVocabularyImportSpecification != null ? customVocabularyImportSpecification.build() : null;
        }

        @Override
        public final Builder customVocabularyImportSpecification(CustomVocabularyImportSpecification customVocabularyImportSpecification) {
            this.customVocabularyImportSpecification = customVocabularyImportSpecification;
            return this;
        }

        public final TestSetImportResourceSpecification.Builder getTestSetImportResourceSpecification() {
            return this.testSetImportResourceSpecification != null ? this.testSetImportResourceSpecification.toBuilder() : null;
        }

        public final void setTestSetImportResourceSpecification(TestSetImportResourceSpecification.BuilderImpl testSetImportResourceSpecification) {
            this.testSetImportResourceSpecification = testSetImportResourceSpecification != null ? testSetImportResourceSpecification.build() : null;
        }

        @Override
        public final Builder testSetImportResourceSpecification(TestSetImportResourceSpecification testSetImportResourceSpecification) {
            this.testSetImportResourceSpecification = testSetImportResourceSpecification;
            return this;
        }

        public ImportResourceSpecification build() {
            return new ImportResourceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportResourceSpecification> {
        public Builder botImportSpecification(BotImportSpecification var1);

        default public Builder botImportSpecification(Consumer<BotImportSpecification.Builder> botImportSpecification) {
            return this.botImportSpecification((BotImportSpecification)((BotImportSpecification.Builder)BotImportSpecification.builder().applyMutation(botImportSpecification)).build());
        }

        public Builder botLocaleImportSpecification(BotLocaleImportSpecification var1);

        default public Builder botLocaleImportSpecification(Consumer<BotLocaleImportSpecification.Builder> botLocaleImportSpecification) {
            return this.botLocaleImportSpecification((BotLocaleImportSpecification)((BotLocaleImportSpecification.Builder)BotLocaleImportSpecification.builder().applyMutation(botLocaleImportSpecification)).build());
        }

        public Builder customVocabularyImportSpecification(CustomVocabularyImportSpecification var1);

        default public Builder customVocabularyImportSpecification(Consumer<CustomVocabularyImportSpecification.Builder> customVocabularyImportSpecification) {
            return this.customVocabularyImportSpecification((CustomVocabularyImportSpecification)((CustomVocabularyImportSpecification.Builder)CustomVocabularyImportSpecification.builder().applyMutation(customVocabularyImportSpecification)).build());
        }

        public Builder testSetImportResourceSpecification(TestSetImportResourceSpecification var1);

        default public Builder testSetImportResourceSpecification(Consumer<TestSetImportResourceSpecification.Builder> testSetImportResourceSpecification) {
            return this.testSetImportResourceSpecification((TestSetImportResourceSpecification)((TestSetImportResourceSpecification.Builder)TestSetImportResourceSpecification.builder().applyMutation(testSetImportResourceSpecification)).build());
        }
    }
}

