/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotResourceGenerationsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotResourceGenerationsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotResourceGenerationsResponse.getter(ListBotResourceGenerationsResponse::botId)).setter(ListBotResourceGenerationsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListBotResourceGenerationsResponse.getter(ListBotResourceGenerationsResponse::botVersion)).setter(ListBotResourceGenerationsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListBotResourceGenerationsResponse.getter(ListBotResourceGenerationsResponse::localeId)).setter(ListBotResourceGenerationsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<List<GenerationSummary>> GENERATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("generationSummaries").getter(ListBotResourceGenerationsResponse.getter(ListBotResourceGenerationsResponse::generationSummaries)).setter(ListBotResourceGenerationsResponse.setter(Builder::generationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GenerationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotResourceGenerationsResponse.getter(ListBotResourceGenerationsResponse::nextToken)).setter(ListBotResourceGenerationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, GENERATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBotResourceGenerationsResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final List<GenerationSummary> generationSummaries;
    private final String nextToken;

    private ListBotResourceGenerationsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.generationSummaries = builder.generationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final boolean hasGenerationSummaries() {
        return this.generationSummaries != null && !(this.generationSummaries instanceof SdkAutoConstructList);
    }

    public final List<GenerationSummary> generationSummaries() {
        return this.generationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGenerationSummaries() ? this.generationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotResourceGenerationsResponse)) {
            return false;
        }
        ListBotResourceGenerationsResponse other = (ListBotResourceGenerationsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && this.hasGenerationSummaries() == other.hasGenerationSummaries() && Objects.equals(this.generationSummaries(), other.generationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotResourceGenerationsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("GenerationSummaries", this.hasGenerationSummaries() ? this.generationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "generationSummaries": {
                return Optional.ofNullable(clazz.cast(this.generationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("generationSummaries", GENERATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotResourceGenerationsResponse, T> g) {
        return obj -> g.apply((ListBotResourceGenerationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private List<GenerationSummary> generationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotResourceGenerationsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.generationSummaries(model.generationSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<GenerationSummary.Builder> getGenerationSummaries() {
            List<GenerationSummary.Builder> result = GenerationSummaryListCopier.copyToBuilder(this.generationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGenerationSummaries(Collection<GenerationSummary.BuilderImpl> generationSummaries) {
            this.generationSummaries = GenerationSummaryListCopier.copyFromBuilder(generationSummaries);
        }

        @Override
        public final Builder generationSummaries(Collection<GenerationSummary> generationSummaries) {
            this.generationSummaries = GenerationSummaryListCopier.copy(generationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaries(GenerationSummary ... generationSummaries) {
            this.generationSummaries(Arrays.asList(generationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generationSummaries(Consumer<GenerationSummary.Builder> ... generationSummaries) {
            this.generationSummaries(Stream.of(generationSummaries).map(c -> (GenerationSummary)((GenerationSummary.Builder)GenerationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotResourceGenerationsResponse build() {
            return new ListBotResourceGenerationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotResourceGenerationsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder generationSummaries(Collection<GenerationSummary> var1);

        public Builder generationSummaries(GenerationSummary ... var1);

        public Builder generationSummaries(Consumer<GenerationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

