/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceDataImportStrategy;
import software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.Tag;
import software.amazon.awssdk.services.lookoutequipment.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportModelVersionRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ImportModelVersionRequest> {
    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelVersionArn").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::sourceModelVersionArn)).setter(ImportModelVersionRequest.setter(Builder::sourceModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::modelName)).setter(ImportModelVersionRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::datasetName)).setter(ImportModelVersionRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::labelsInputConfiguration)).setter(ImportModelVersionRequest.setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::clientToken)).setter(ImportModelVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::roleArn)).setter(ImportModelVersionRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::serverSideKmsKeyId)).setter(ImportModelVersionRequest.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::tags)).setter(ImportModelVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INFERENCE_DATA_IMPORT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceDataImportStrategy").getter(ImportModelVersionRequest.getter(ImportModelVersionRequest::inferenceDataImportStrategyAsString)).setter(ImportModelVersionRequest.setter(Builder::inferenceDataImportStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceDataImportStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MODEL_VERSION_ARN_FIELD, MODEL_NAME_FIELD, DATASET_NAME_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, TAGS_FIELD, INFERENCE_DATA_IMPORT_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportModelVersionRequest.memberNameToFieldInitializer();
    private final String sourceModelVersionArn;
    private final String modelName;
    private final String datasetName;
    private final LabelsInputConfiguration labelsInputConfiguration;
    private final String clientToken;
    private final String roleArn;
    private final String serverSideKmsKeyId;
    private final List<Tag> tags;
    private final String inferenceDataImportStrategy;

    private ImportModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.modelName = builder.modelName;
        this.datasetName = builder.datasetName;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.clientToken = builder.clientToken;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.tags = builder.tags;
        this.inferenceDataImportStrategy = builder.inferenceDataImportStrategy;
    }

    public final String sourceModelVersionArn() {
        return this.sourceModelVersionArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final LabelsInputConfiguration labelsInputConfiguration() {
        return this.labelsInputConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final InferenceDataImportStrategy inferenceDataImportStrategy() {
        return InferenceDataImportStrategy.fromValue(this.inferenceDataImportStrategy);
    }

    public final String inferenceDataImportStrategyAsString() {
        return this.inferenceDataImportStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceDataImportStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportModelVersionRequest)) {
            return false;
        }
        ImportModelVersionRequest other = (ImportModelVersionRequest)((Object)obj);
        return Objects.equals(this.sourceModelVersionArn(), other.sourceModelVersionArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.labelsInputConfiguration(), other.labelsInputConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.inferenceDataImportStrategyAsString(), other.inferenceDataImportStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportModelVersionRequest").add("SourceModelVersionArn", (Object)this.sourceModelVersionArn()).add("ModelName", (Object)this.modelName()).add("DatasetName", (Object)this.datasetName()).add("LabelsInputConfiguration", (Object)this.labelsInputConfiguration()).add("ClientToken", (Object)this.clientToken()).add("RoleArn", (Object)this.roleArn()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("InferenceDataImportStrategy", (Object)this.inferenceDataImportStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelVersionArn()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "LabelsInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelsInputConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "InferenceDataImportStrategy": {
                return Optional.ofNullable(clazz.cast(this.inferenceDataImportStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceModelVersionArn", SOURCE_MODEL_VERSION_ARN_FIELD);
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("LabelsInputConfiguration", LABELS_INPUT_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("InferenceDataImportStrategy", INFERENCE_DATA_IMPORT_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportModelVersionRequest, T> g) {
        return obj -> g.apply((ImportModelVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String sourceModelVersionArn;
        private String modelName;
        private String datasetName;
        private LabelsInputConfiguration labelsInputConfiguration;
        private String clientToken;
        private String roleArn;
        private String serverSideKmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String inferenceDataImportStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportModelVersionRequest model) {
            super(model);
            this.sourceModelVersionArn(model.sourceModelVersionArn);
            this.modelName(model.modelName);
            this.datasetName(model.datasetName);
            this.labelsInputConfiguration(model.labelsInputConfiguration);
            this.clientToken(model.clientToken);
            this.roleArn(model.roleArn);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.tags(model.tags);
            this.inferenceDataImportStrategy(model.inferenceDataImportStrategy);
        }

        public final String getSourceModelVersionArn() {
            return this.sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return this.labelsInputConfiguration != null ? this.labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInferenceDataImportStrategy() {
            return this.inferenceDataImportStrategy;
        }

        public final void setInferenceDataImportStrategy(String inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy = inferenceDataImportStrategy;
        }

        @Override
        public final Builder inferenceDataImportStrategy(String inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy = inferenceDataImportStrategy;
            return this;
        }

        @Override
        public final Builder inferenceDataImportStrategy(InferenceDataImportStrategy inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy(inferenceDataImportStrategy == null ? null : inferenceDataImportStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportModelVersionRequest build() {
            return new ImportModelVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportModelVersionRequest> {
        public Builder sourceModelVersionArn(String var1);

        public Builder modelName(String var1);

        public Builder datasetName(String var1);

        public Builder labelsInputConfiguration(LabelsInputConfiguration var1);

        default public Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return this.labelsInputConfiguration((LabelsInputConfiguration)((LabelsInputConfiguration.Builder)LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder roleArn(String var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder inferenceDataImportStrategy(String var1);

        public Builder inferenceDataImportStrategy(InferenceDataImportStrategy var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

