/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceEventsRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListInferenceEventsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceEventsRequest.getter(ListInferenceEventsRequest::nextToken)).setter(ListInferenceEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInferenceEventsRequest.getter(ListInferenceEventsRequest::maxResults)).setter(ListInferenceEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(ListInferenceEventsRequest.getter(ListInferenceEventsRequest::inferenceSchedulerName)).setter(ListInferenceEventsRequest.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<Instant> INTERVAL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IntervalStartTime").getter(ListInferenceEventsRequest.getter(ListInferenceEventsRequest::intervalStartTime)).setter(ListInferenceEventsRequest.setter(Builder::intervalStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalStartTime").build()}).build();
    private static final SdkField<Instant> INTERVAL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("IntervalEndTime").getter(ListInferenceEventsRequest.getter(ListInferenceEventsRequest::intervalEndTime)).setter(ListInferenceEventsRequest.setter(Builder::intervalEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INTERVAL_START_TIME_FIELD, INTERVAL_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceEventsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String inferenceSchedulerName;
    private final Instant intervalStartTime;
    private final Instant intervalEndTime;

    private ListInferenceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.intervalStartTime = builder.intervalStartTime;
        this.intervalEndTime = builder.intervalEndTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final Instant intervalStartTime() {
        return this.intervalStartTime;
    }

    public final Instant intervalEndTime() {
        return this.intervalEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceEventsRequest)) {
            return false;
        }
        ListInferenceEventsRequest other = (ListInferenceEventsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.intervalStartTime(), other.intervalStartTime()) && Objects.equals(this.intervalEndTime(), other.intervalEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceEventsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("IntervalStartTime", (Object)this.intervalStartTime()).add("IntervalEndTime", (Object)this.intervalEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "IntervalStartTime": {
                return Optional.ofNullable(clazz.cast(this.intervalStartTime()));
            }
            case "IntervalEndTime": {
                return Optional.ofNullable(clazz.cast(this.intervalEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("IntervalStartTime", INTERVAL_START_TIME_FIELD);
        map.put("IntervalEndTime", INTERVAL_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceEventsRequest, T> g) {
        return obj -> g.apply((ListInferenceEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String inferenceSchedulerName;
        private Instant intervalStartTime;
        private Instant intervalEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceEventsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.intervalStartTime(model.intervalStartTime);
            this.intervalEndTime(model.intervalEndTime);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getIntervalStartTime() {
            return this.intervalStartTime;
        }

        public final void setIntervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
        }

        @Override
        public final Builder intervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
            return this;
        }

        public final Instant getIntervalEndTime() {
            return this.intervalEndTime;
        }

        public final void setIntervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
        }

        @Override
        public final Builder intervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceEventsRequest build() {
            return new ListInferenceEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceEventsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder intervalStartTime(Instant var1);

        public Builder intervalEndTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

