/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse;

public class ListRetrainingSchedulersIterable
implements SdkIterable<ListRetrainingSchedulersResponse> {
    private final LookoutEquipmentClient client;
    private final ListRetrainingSchedulersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRetrainingSchedulersIterable(LookoutEquipmentClient client, ListRetrainingSchedulersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRetrainingSchedulersResponseFetcher();
    }

    public Iterator<ListRetrainingSchedulersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRetrainingSchedulersResponseFetcher
    implements SyncPageFetcher<ListRetrainingSchedulersResponse> {
        private ListRetrainingSchedulersResponseFetcher() {
        }

        public boolean hasNextPage(ListRetrainingSchedulersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRetrainingSchedulersResponse nextPage(ListRetrainingSchedulersResponse previousPage) {
            if (previousPage == null) {
                return ListRetrainingSchedulersIterable.this.client.listRetrainingSchedulers(ListRetrainingSchedulersIterable.this.firstRequest);
            }
            return ListRetrainingSchedulersIterable.this.client.listRetrainingSchedulers((ListRetrainingSchedulersRequest)((Object)ListRetrainingSchedulersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

