/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateEgressGatewayBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFailoverConfig;
import software.amazon.awssdk.services.mediaconnect.model.UpdateIngressGatewayBridgeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBridgeRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateBridgeRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(UpdateBridgeRequest.getter(UpdateBridgeRequest::bridgeArn)).setter(UpdateBridgeRequest.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("bridgeArn").build()}).build();
    private static final SdkField<UpdateEgressGatewayBridgeRequest> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressGatewayBridge").getter(UpdateBridgeRequest.getter(UpdateBridgeRequest::egressGatewayBridge)).setter(UpdateBridgeRequest.setter(Builder::egressGatewayBridge)).constructor(UpdateEgressGatewayBridgeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build()}).build();
    private static final SdkField<UpdateIngressGatewayBridgeRequest> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressGatewayBridge").getter(UpdateBridgeRequest.getter(UpdateBridgeRequest::ingressGatewayBridge)).setter(UpdateBridgeRequest.setter(Builder::ingressGatewayBridge)).constructor(UpdateIngressGatewayBridgeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build()}).build();
    private static final SdkField<UpdateFailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceFailoverConfig").getter(UpdateBridgeRequest.getter(UpdateBridgeRequest::sourceFailoverConfig)).setter(UpdateBridgeRequest.setter(Builder::sourceFailoverConfig)).constructor(UpdateFailoverConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, EGRESS_GATEWAY_BRIDGE_FIELD, INGRESS_GATEWAY_BRIDGE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBridgeRequest.memberNameToFieldInitializer();
    private final String bridgeArn;
    private final UpdateEgressGatewayBridgeRequest egressGatewayBridge;
    private final UpdateIngressGatewayBridgeRequest ingressGatewayBridge;
    private final UpdateFailoverConfig sourceFailoverConfig;

    private UpdateBridgeRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final UpdateEgressGatewayBridgeRequest egressGatewayBridge() {
        return this.egressGatewayBridge;
    }

    public final UpdateIngressGatewayBridgeRequest ingressGatewayBridge() {
        return this.ingressGatewayBridge;
    }

    public final UpdateFailoverConfig sourceFailoverConfig() {
        return this.sourceFailoverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFailoverConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeRequest)) {
            return false;
        }
        UpdateBridgeRequest other = (UpdateBridgeRequest)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.egressGatewayBridge(), other.egressGatewayBridge()) && Objects.equals(this.ingressGatewayBridge(), other.ingressGatewayBridge()) && Objects.equals(this.sourceFailoverConfig(), other.sourceFailoverConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBridgeRequest").add("BridgeArn", (Object)this.bridgeArn()).add("EgressGatewayBridge", (Object)this.egressGatewayBridge()).add("IngressGatewayBridge", (Object)this.ingressGatewayBridge()).add("SourceFailoverConfig", (Object)this.sourceFailoverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "EgressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.egressGatewayBridge()));
            }
            case "IngressGatewayBridge": {
                return Optional.ofNullable(clazz.cast(this.ingressGatewayBridge()));
            }
            case "SourceFailoverConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceFailoverConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("egressGatewayBridge", EGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("ingressGatewayBridge", INGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeRequest, T> g) {
        return obj -> g.apply((UpdateBridgeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private UpdateEgressGatewayBridgeRequest egressGatewayBridge;
        private UpdateIngressGatewayBridgeRequest ingressGatewayBridge;
        private UpdateFailoverConfig sourceFailoverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeRequest model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.egressGatewayBridge(model.egressGatewayBridge);
            this.ingressGatewayBridge(model.ingressGatewayBridge);
            this.sourceFailoverConfig(model.sourceFailoverConfig);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateEgressGatewayBridgeRequest.Builder getEgressGatewayBridge() {
            return this.egressGatewayBridge != null ? this.egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(UpdateEgressGatewayBridgeRequest.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(UpdateEgressGatewayBridgeRequest egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final UpdateIngressGatewayBridgeRequest.Builder getIngressGatewayBridge() {
            return this.ingressGatewayBridge != null ? this.ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(UpdateIngressGatewayBridgeRequest.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(UpdateIngressGatewayBridgeRequest ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final UpdateFailoverConfig.Builder getSourceFailoverConfig() {
            return this.sourceFailoverConfig != null ? this.sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(UpdateFailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeRequest build() {
            return new UpdateBridgeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBridgeRequest> {
        public Builder bridgeArn(String var1);

        public Builder egressGatewayBridge(UpdateEgressGatewayBridgeRequest var1);

        default public Builder egressGatewayBridge(Consumer<UpdateEgressGatewayBridgeRequest.Builder> egressGatewayBridge) {
            return this.egressGatewayBridge((UpdateEgressGatewayBridgeRequest)((UpdateEgressGatewayBridgeRequest.Builder)UpdateEgressGatewayBridgeRequest.builder().applyMutation(egressGatewayBridge)).build());
        }

        public Builder ingressGatewayBridge(UpdateIngressGatewayBridgeRequest var1);

        default public Builder ingressGatewayBridge(Consumer<UpdateIngressGatewayBridgeRequest.Builder> ingressGatewayBridge) {
            return this.ingressGatewayBridge((UpdateIngressGatewayBridgeRequest)((UpdateIngressGatewayBridgeRequest.Builder)UpdateIngressGatewayBridgeRequest.builder().applyMutation(ingressGatewayBridge)).build());
        }

        public Builder sourceFailoverConfig(UpdateFailoverConfig var1);

        default public Builder sourceFailoverConfig(Consumer<UpdateFailoverConfig.Builder> sourceFailoverConfig) {
            return this.sourceFailoverConfig((UpdateFailoverConfig)((UpdateFailoverConfig.Builder)UpdateFailoverConfig.builder().applyMutation(sourceFailoverConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

