/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Commitment;
import software.amazon.awssdk.services.mediaconvert.model.RenewalType;
import software.amazon.awssdk.services.mediaconvert.model.ReservationPlanStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservationPlan> {
    private static final SdkField<String> COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Commitment").getter(ReservationPlan.getter(ReservationPlan::commitmentAsString)).setter(ReservationPlan.setter(Builder::commitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(ReservationPlan.getter(ReservationPlan::expiresAt)).setter(ReservationPlan.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<Instant> PURCHASED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PurchasedAt").getter(ReservationPlan.getter(ReservationPlan::purchasedAt)).setter(ReservationPlan.setter(Builder::purchasedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchasedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> RENEWAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenewalType").getter(ReservationPlan.getter(ReservationPlan::renewalTypeAsString)).setter(ReservationPlan.setter(Builder::renewalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalType").build()}).build();
    private static final SdkField<Integer> RESERVED_SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReservedSlots").getter(ReservationPlan.getter(ReservationPlan::reservedSlots)).setter(ReservationPlan.setter(Builder::reservedSlots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedSlots").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReservationPlan.getter(ReservationPlan::statusAsString)).setter(ReservationPlan.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITMENT_FIELD, EXPIRES_AT_FIELD, PURCHASED_AT_FIELD, RENEWAL_TYPE_FIELD, RESERVED_SLOTS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservationPlan.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String commitment;
    private final Instant expiresAt;
    private final Instant purchasedAt;
    private final String renewalType;
    private final Integer reservedSlots;
    private final String status;

    private ReservationPlan(BuilderImpl builder) {
        this.commitment = builder.commitment;
        this.expiresAt = builder.expiresAt;
        this.purchasedAt = builder.purchasedAt;
        this.renewalType = builder.renewalType;
        this.reservedSlots = builder.reservedSlots;
        this.status = builder.status;
    }

    public final Commitment commitment() {
        return Commitment.fromValue(this.commitment);
    }

    public final String commitmentAsString() {
        return this.commitment;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final Instant purchasedAt() {
        return this.purchasedAt;
    }

    public final RenewalType renewalType() {
        return RenewalType.fromValue(this.renewalType);
    }

    public final String renewalTypeAsString() {
        return this.renewalType;
    }

    public final Integer reservedSlots() {
        return this.reservedSlots;
    }

    public final ReservationPlanStatus status() {
        return ReservationPlanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedSlots());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPlan)) {
            return false;
        }
        ReservationPlan other = (ReservationPlan)obj;
        return Objects.equals(this.commitmentAsString(), other.commitmentAsString()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.purchasedAt(), other.purchasedAt()) && Objects.equals(this.renewalTypeAsString(), other.renewalTypeAsString()) && Objects.equals(this.reservedSlots(), other.reservedSlots()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReservationPlan").add("Commitment", (Object)this.commitmentAsString()).add("ExpiresAt", (Object)this.expiresAt()).add("PurchasedAt", (Object)this.purchasedAt()).add("RenewalType", (Object)this.renewalTypeAsString()).add("ReservedSlots", (Object)this.reservedSlots()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Commitment": {
                return Optional.ofNullable(clazz.cast(this.commitmentAsString()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "PurchasedAt": {
                return Optional.ofNullable(clazz.cast(this.purchasedAt()));
            }
            case "RenewalType": {
                return Optional.ofNullable(clazz.cast(this.renewalTypeAsString()));
            }
            case "ReservedSlots": {
                return Optional.ofNullable(clazz.cast(this.reservedSlots()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commitment", COMMITMENT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("purchasedAt", PURCHASED_AT_FIELD);
        map.put("renewalType", RENEWAL_TYPE_FIELD);
        map.put("reservedSlots", RESERVED_SLOTS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservationPlan, T> g) {
        return obj -> g.apply((ReservationPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commitment;
        private Instant expiresAt;
        private Instant purchasedAt;
        private String renewalType;
        private Integer reservedSlots;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPlan model) {
            this.commitment(model.commitment);
            this.expiresAt(model.expiresAt);
            this.purchasedAt(model.purchasedAt);
            this.renewalType(model.renewalType);
            this.reservedSlots(model.reservedSlots);
            this.status(model.status);
        }

        public final String getCommitment() {
            return this.commitment;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        @Override
        public final Builder commitment(Commitment commitment) {
            this.commitment(commitment == null ? null : commitment.toString());
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final Instant getPurchasedAt() {
            return this.purchasedAt;
        }

        public final void setPurchasedAt(Instant purchasedAt) {
            this.purchasedAt = purchasedAt;
        }

        @Override
        public final Builder purchasedAt(Instant purchasedAt) {
            this.purchasedAt = purchasedAt;
            return this;
        }

        public final String getRenewalType() {
            return this.renewalType;
        }

        public final void setRenewalType(String renewalType) {
            this.renewalType = renewalType;
        }

        @Override
        public final Builder renewalType(String renewalType) {
            this.renewalType = renewalType;
            return this;
        }

        @Override
        public final Builder renewalType(RenewalType renewalType) {
            this.renewalType(renewalType == null ? null : renewalType.toString());
            return this;
        }

        public final Integer getReservedSlots() {
            return this.reservedSlots;
        }

        public final void setReservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
        }

        @Override
        public final Builder reservedSlots(Integer reservedSlots) {
            this.reservedSlots = reservedSlots;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservationPlanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ReservationPlan build() {
            return new ReservationPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservationPlan> {
        public Builder commitment(String var1);

        public Builder commitment(Commitment var1);

        public Builder expiresAt(Instant var1);

        public Builder purchasedAt(Instant var1);

        public Builder renewalType(String var1);

        public Builder renewalType(RenewalType var1);

        public Builder reservedSlots(Integer var1);

        public Builder status(String var1);

        public Builder status(ReservationPlanStatus var1);
    }
}

