/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.ImportIDsFilterCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListImportsRequestFilters> {
    private static final SdkField<List<String>> IMPORT_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importIDs").getter(ListImportsRequestFilters.getter(ListImportsRequestFilters::importIDs)).setter(ListImportsRequestFilters.setter(Builder::importIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImportsRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> importIDs;

    private ListImportsRequestFilters(BuilderImpl builder) {
        this.importIDs = builder.importIDs;
    }

    public final boolean hasImportIDs() {
        return this.importIDs != null && !(this.importIDs instanceof SdkAutoConstructList);
    }

    public final List<String> importIDs() {
        return this.importIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportIDs() ? this.importIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsRequestFilters)) {
            return false;
        }
        ListImportsRequestFilters other = (ListImportsRequestFilters)obj;
        return this.hasImportIDs() == other.hasImportIDs() && Objects.equals(this.importIDs(), other.importIDs());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportsRequestFilters").add("ImportIDs", this.hasImportIDs() ? this.importIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importIDs": {
                return Optional.ofNullable(clazz.cast(this.importIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("importIDs", IMPORT_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsRequestFilters, T> g) {
        return obj -> g.apply((ListImportsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> importIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsRequestFilters model) {
            this.importIDs(model.importIDs);
        }

        public final Collection<String> getImportIDs() {
            if (this.importIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.importIDs;
        }

        public final void setImportIDs(Collection<String> importIDs) {
            this.importIDs = ImportIDsFilterCopier.copy(importIDs);
        }

        @Override
        public final Builder importIDs(Collection<String> importIDs) {
            this.importIDs = ImportIDsFilterCopier.copy(importIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importIDs(String ... importIDs) {
            this.importIDs(Arrays.asList(importIDs));
            return this;
        }

        public ListImportsRequestFilters build() {
            return new ListImportsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListImportsRequestFilters> {
        public Builder importIDs(Collection<String> var1);

        public Builder importIDs(String ... var1);
    }
}

