/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.ActionIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateActionsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateActionsRequestFilters> {
    private static final SdkField<List<String>> ACTION_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionIDs").getter(TemplateActionsRequestFilters.getter(TemplateActionsRequestFilters::actionIDs)).setter(TemplateActionsRequestFilters.setter(Builder::actionIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateActionsRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> actionIDs;

    private TemplateActionsRequestFilters(BuilderImpl builder) {
        this.actionIDs = builder.actionIDs;
    }

    public final boolean hasActionIDs() {
        return this.actionIDs != null && !(this.actionIDs instanceof SdkAutoConstructList);
    }

    public final List<String> actionIDs() {
        return this.actionIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionIDs() ? this.actionIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateActionsRequestFilters)) {
            return false;
        }
        TemplateActionsRequestFilters other = (TemplateActionsRequestFilters)obj;
        return this.hasActionIDs() == other.hasActionIDs() && Objects.equals(this.actionIDs(), other.actionIDs());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateActionsRequestFilters").add("ActionIDs", this.hasActionIDs() ? this.actionIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionIDs": {
                return Optional.ofNullable(clazz.cast(this.actionIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("actionIDs", ACTION_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateActionsRequestFilters, T> g) {
        return obj -> g.apply((TemplateActionsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actionIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateActionsRequestFilters model) {
            this.actionIDs(model.actionIDs);
        }

        public final Collection<String> getActionIDs() {
            if (this.actionIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionIDs;
        }

        public final void setActionIDs(Collection<String> actionIDs) {
            this.actionIDs = ActionIDsCopier.copy(actionIDs);
        }

        @Override
        public final Builder actionIDs(Collection<String> actionIDs) {
            this.actionIDs = ActionIDsCopier.copy(actionIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIDs(String ... actionIDs) {
            this.actionIDs(Arrays.asList(actionIDs));
            return this;
        }

        public TemplateActionsRequestFilters build() {
            return new TemplateActionsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateActionsRequestFilters> {
        public Builder actionIDs(Collection<String> var1);

        public Builder actionIDs(String ... var1);
    }
}

