/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ExternalRegionCodeListCopier;
import software.amazon.awssdk.services.networkmanager.model.ServiceInsertionSegments;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkNetworkFunctionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkNetworkFunctionGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CoreNetworkNetworkFunctionGroup.getter(CoreNetworkNetworkFunctionGroup::name)).setter(CoreNetworkNetworkFunctionGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeLocations").getter(CoreNetworkNetworkFunctionGroup.getter(CoreNetworkNetworkFunctionGroup::edgeLocations)).setter(CoreNetworkNetworkFunctionGroup.setter(Builder::edgeLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceInsertionSegments> SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Segments").getter(CoreNetworkNetworkFunctionGroup.getter(CoreNetworkNetworkFunctionGroup::segments)).setter(CoreNetworkNetworkFunctionGroup.setter(Builder::segments)).constructor(ServiceInsertionSegments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segments").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EDGE_LOCATIONS_FIELD, SEGMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoreNetworkNetworkFunctionGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> edgeLocations;
    private final ServiceInsertionSegments segments;

    private CoreNetworkNetworkFunctionGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.edgeLocations = builder.edgeLocations;
        this.segments = builder.segments;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasEdgeLocations() {
        return this.edgeLocations != null && !(this.edgeLocations instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLocations() {
        return this.edgeLocations;
    }

    public final ServiceInsertionSegments segments() {
        return this.segments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLocations() ? this.edgeLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segments());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkNetworkFunctionGroup)) {
            return false;
        }
        CoreNetworkNetworkFunctionGroup other = (CoreNetworkNetworkFunctionGroup)obj;
        return Objects.equals(this.name(), other.name()) && this.hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(this.edgeLocations(), other.edgeLocations()) && Objects.equals(this.segments(), other.segments());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkNetworkFunctionGroup").add("Name", (Object)this.name()).add("EdgeLocations", this.hasEdgeLocations() ? this.edgeLocations() : null).add("Segments", (Object)this.segments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EdgeLocations": {
                return Optional.ofNullable(clazz.cast(this.edgeLocations()));
            }
            case "Segments": {
                return Optional.ofNullable(clazz.cast(this.segments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
        map.put("Segments", SEGMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkNetworkFunctionGroup, T> g) {
        return obj -> g.apply((CoreNetworkNetworkFunctionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();
        private ServiceInsertionSegments segments;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkNetworkFunctionGroup model) {
            this.name(model.name);
            this.edgeLocations(model.edgeLocations);
            this.segments(model.segments);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (this.edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String ... edgeLocations) {
            this.edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        public final ServiceInsertionSegments.Builder getSegments() {
            return this.segments != null ? this.segments.toBuilder() : null;
        }

        public final void setSegments(ServiceInsertionSegments.BuilderImpl segments) {
            this.segments = segments != null ? segments.build() : null;
        }

        @Override
        public final Builder segments(ServiceInsertionSegments segments) {
            this.segments = segments;
            return this;
        }

        public CoreNetworkNetworkFunctionGroup build() {
            return new CoreNetworkNetworkFunctionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkNetworkFunctionGroup> {
        public Builder name(String var1);

        public Builder edgeLocations(Collection<String> var1);

        public Builder edgeLocations(String ... var1);

        public Builder segments(ServiceInsertionSegments var1);

        default public Builder segments(Consumer<ServiceInsertionSegments.Builder> segments) {
            return this.segments((ServiceInsertionSegments)((ServiceInsertionSegments.Builder)ServiceInsertionSegments.builder().applyMutation(segments)).build());
        }
    }
}

