/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetLinksRequest;
import software.amazon.awssdk.services.networkmanager.model.GetLinksResponse;
import software.amazon.awssdk.services.networkmanager.model.Link;

public class GetLinksIterable
implements SdkIterable<GetLinksResponse> {
    private final NetworkManagerClient client;
    private final GetLinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLinksIterable(NetworkManagerClient client, GetLinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetLinksResponseFetcher();
    }

    public Iterator<GetLinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Link> links() {
        Function<GetLinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.links() != null) {
                return response.links().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetLinksResponseFetcher
    implements SyncPageFetcher<GetLinksResponse> {
        private GetLinksResponseFetcher() {
        }

        public boolean hasNextPage(GetLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLinksResponse nextPage(GetLinksResponse previousPage) {
            if (previousPage == null) {
                return GetLinksIterable.this.client.getLinks(GetLinksIterable.this.firstRequest);
            }
            return GetLinksIterable.this.client.getLinks((GetLinksRequest)((Object)GetLinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

