/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.ReadSetFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadSetRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, GetReadSetRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReadSetRequest.getter(GetReadSetRequest::id)).setter(GetReadSetRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(GetReadSetRequest.getter(GetReadSetRequest::sequenceStoreId)).setter(GetReadSetRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("file").getter(GetReadSetRequest.getter(GetReadSetRequest::fileAsString)).setter(GetReadSetRequest.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("file").build()}).build();
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("partNumber").getter(GetReadSetRequest.getter(GetReadSetRequest::partNumber)).setter(GetReadSetRequest.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SEQUENCE_STORE_ID_FIELD, FILE_FIELD, PART_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetReadSetRequest.memberNameToFieldInitializer();
    private final String id;
    private final String sequenceStoreId;
    private final String file;
    private final Integer partNumber;

    private GetReadSetRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.file = builder.file;
        this.partNumber = builder.partNumber;
    }

    public final String id() {
        return this.id;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final ReadSetFile file() {
        return ReadSetFile.fromValue(this.file);
    }

    public final String fileAsString() {
        return this.file;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetRequest)) {
            return false;
        }
        GetReadSetRequest other = (GetReadSetRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.fileAsString(), other.fileAsString()) && Objects.equals(this.partNumber(), other.partNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadSetRequest").add("Id", (Object)this.id()).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("File", (Object)this.fileAsString()).add("PartNumber", (Object)this.partNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.fileAsString()));
            }
            case "partNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("file", FILE_FIELD);
        map.put("partNumber", PART_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetRequest, T> g) {
        return obj -> g.apply((GetReadSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String id;
        private String sequenceStoreId;
        private String file;
        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetRequest model) {
            super(model);
            this.id(model.id);
            this.sequenceStoreId(model.sequenceStoreId);
            this.file(model.file);
            this.partNumber(model.partNumber);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getFile() {
            return this.file;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        @Override
        public final Builder file(ReadSetFile file) {
            this.file(file == null ? null : file.toString());
            return this;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReadSetRequest build() {
            return new GetReadSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadSetRequest> {
        public Builder id(String var1);

        public Builder sequenceStoreId(String var1);

        public Builder file(String var1);

        public Builder file(ReadSetFile var1);

        public Builder partNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

