/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.PropagatedSetLevelTagsCopier;
import software.amazon.awssdk.services.omics.model.S3AccessConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSequenceStoreRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, UpdateSequenceStoreRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::id)).setter(UpdateSequenceStoreRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::name)).setter(UpdateSequenceStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::description)).setter(UpdateSequenceStoreRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::clientToken)).setter(UpdateSequenceStoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fallbackLocation").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::fallbackLocation)).setter(UpdateSequenceStoreRequest.setter(Builder::fallbackLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()}).build();
    private static final SdkField<List<String>> PROPAGATED_SET_LEVEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propagatedSetLevelTags").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::propagatedSetLevelTags)).setter(UpdateSequenceStoreRequest.setter(Builder::propagatedSetLevelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatedSetLevelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3AccessConfig> S3_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3AccessConfig").getter(UpdateSequenceStoreRequest.getter(UpdateSequenceStoreRequest::s3AccessConfig)).setter(UpdateSequenceStoreRequest.setter(Builder::s3AccessConfig)).constructor(S3AccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, FALLBACK_LOCATION_FIELD, PROPAGATED_SET_LEVEL_TAGS_FIELD, S3_ACCESS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSequenceStoreRequest.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String description;
    private final String clientToken;
    private final String fallbackLocation;
    private final List<String> propagatedSetLevelTags;
    private final S3AccessConfig s3AccessConfig;

    private UpdateSequenceStoreRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.fallbackLocation = builder.fallbackLocation;
        this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
        this.s3AccessConfig = builder.s3AccessConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String fallbackLocation() {
        return this.fallbackLocation;
    }

    public final boolean hasPropagatedSetLevelTags() {
        return this.propagatedSetLevelTags != null && !(this.propagatedSetLevelTags instanceof SdkAutoConstructList);
    }

    public final List<String> propagatedSetLevelTags() {
        return this.propagatedSetLevelTags;
    }

    public final S3AccessConfig s3AccessConfig() {
        return this.s3AccessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropagatedSetLevelTags() ? this.propagatedSetLevelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSequenceStoreRequest)) {
            return false;
        }
        UpdateSequenceStoreRequest other = (UpdateSequenceStoreRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.fallbackLocation(), other.fallbackLocation()) && this.hasPropagatedSetLevelTags() == other.hasPropagatedSetLevelTags() && Objects.equals(this.propagatedSetLevelTags(), other.propagatedSetLevelTags()) && Objects.equals(this.s3AccessConfig(), other.s3AccessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSequenceStoreRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("FallbackLocation", (Object)this.fallbackLocation()).add("PropagatedSetLevelTags", this.hasPropagatedSetLevelTags() ? this.propagatedSetLevelTags() : null).add("S3AccessConfig", (Object)this.s3AccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "fallbackLocation": {
                return Optional.ofNullable(clazz.cast(this.fallbackLocation()));
            }
            case "propagatedSetLevelTags": {
                return Optional.ofNullable(clazz.cast(this.propagatedSetLevelTags()));
            }
            case "s3AccessConfig": {
                return Optional.ofNullable(clazz.cast(this.s3AccessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
        map.put("propagatedSetLevelTags", PROPAGATED_SET_LEVEL_TAGS_FIELD);
        map.put("s3AccessConfig", S3_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSequenceStoreRequest, T> g) {
        return obj -> g.apply((UpdateSequenceStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private String clientToken;
        private String fallbackLocation;
        private List<String> propagatedSetLevelTags = DefaultSdkAutoConstructList.getInstance();
        private S3AccessConfig s3AccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSequenceStoreRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.fallbackLocation(model.fallbackLocation);
            this.propagatedSetLevelTags(model.propagatedSetLevelTags);
            this.s3AccessConfig(model.s3AccessConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFallbackLocation() {
            return this.fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final Collection<String> getPropagatedSetLevelTags() {
            if (this.propagatedSetLevelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propagatedSetLevelTags;
        }

        public final void setPropagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
        }

        @Override
        public final Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatedSetLevelTags(String ... propagatedSetLevelTags) {
            this.propagatedSetLevelTags(Arrays.asList(propagatedSetLevelTags));
            return this;
        }

        public final S3AccessConfig.Builder getS3AccessConfig() {
            return this.s3AccessConfig != null ? this.s3AccessConfig.toBuilder() : null;
        }

        public final void setS3AccessConfig(S3AccessConfig.BuilderImpl s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig != null ? s3AccessConfig.build() : null;
        }

        @Override
        public final Builder s3AccessConfig(S3AccessConfig s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSequenceStoreRequest build() {
            return new UpdateSequenceStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSequenceStoreRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder fallbackLocation(String var1);

        public Builder propagatedSetLevelTags(Collection<String> var1);

        public Builder propagatedSetLevelTags(String ... var1);

        public Builder s3AccessConfig(S3AccessConfig var1);

        default public Builder s3AccessConfig(Consumer<S3AccessConfig.Builder> s3AccessConfig) {
            return this.s3AccessConfig((S3AccessConfig)((S3AccessConfig.Builder)S3AccessConfig.builder().applyMutation(s3AccessConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

