/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneActionType;
import software.amazon.awssdk.services.opensearch.model.ScheduledAutoTuneSeverityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledAutoTuneDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledAutoTuneDetails> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Date").getter(ScheduledAutoTuneDetails.getter(ScheduledAutoTuneDetails::date)).setter(ScheduledAutoTuneDetails.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(ScheduledAutoTuneDetails.getter(ScheduledAutoTuneDetails::actionTypeAsString)).setter(ScheduledAutoTuneDetails.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ScheduledAutoTuneDetails.getter(ScheduledAutoTuneDetails::action)).setter(ScheduledAutoTuneDetails.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ScheduledAutoTuneDetails.getter(ScheduledAutoTuneDetails::severityAsString)).setter(ScheduledAutoTuneDetails.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, ACTION_TYPE_FIELD, ACTION_FIELD, SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledAutoTuneDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant date;
    private final String actionType;
    private final String action;
    private final String severity;

    private ScheduledAutoTuneDetails(BuilderImpl builder) {
        this.date = builder.date;
        this.actionType = builder.actionType;
        this.action = builder.action;
        this.severity = builder.severity;
    }

    public final Instant date() {
        return this.date;
    }

    public final ScheduledAutoTuneActionType actionType() {
        return ScheduledAutoTuneActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String action() {
        return this.action;
    }

    public final ScheduledAutoTuneSeverityType severity() {
        return ScheduledAutoTuneSeverityType.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAutoTuneDetails)) {
            return false;
        }
        ScheduledAutoTuneDetails other = (ScheduledAutoTuneDetails)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.severityAsString(), other.severityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledAutoTuneDetails").add("Date", (Object)this.date()).add("ActionType", (Object)this.actionTypeAsString()).add("Action", (Object)this.action()).add("Severity", (Object)this.severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Date", DATE_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAutoTuneDetails, T> g) {
        return obj -> g.apply((ScheduledAutoTuneDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private String actionType;
        private String action;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAutoTuneDetails model) {
            this.date(model.date);
            this.actionType(model.actionType);
            this.action(model.action);
            this.severity(model.severity);
        }

        public final Instant getDate() {
            return this.date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ScheduledAutoTuneActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ScheduledAutoTuneSeverityType severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public ScheduledAutoTuneDetails build() {
            return new ScheduledAutoTuneDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledAutoTuneDetails> {
        public Builder date(Instant var1);

        public Builder actionType(String var1);

        public Builder actionType(ScheduledAutoTuneActionType var1);

        public Builder action(String var1);

        public Builder severity(String var1);

        public Builder severity(ScheduledAutoTuneSeverityType var1);
    }
}

