/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserProfile> {
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserArn").getter(UserProfile.getter(UserProfile::iamUserArn)).setter(UserProfile.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UserProfile.getter(UserProfile::name)).setter(UserProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SSH_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshUsername").getter(UserProfile.getter(UserProfile::sshUsername)).setter(UserProfile.setter(Builder::sshUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshUsername").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SshPublicKey").getter(UserProfile.getter(UserProfile::sshPublicKey)).setter(UserProfile.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()}).build();
    private static final SdkField<Boolean> ALLOW_SELF_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSelfManagement").getter(UserProfile.getter(UserProfile::allowSelfManagement)).setter(UserProfile.setter(Builder::allowSelfManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSelfManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARN_FIELD, NAME_FIELD, SSH_USERNAME_FIELD, SSH_PUBLIC_KEY_FIELD, ALLOW_SELF_MANAGEMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String iamUserArn;
    private final String name;
    private final String sshUsername;
    private final String sshPublicKey;
    private final Boolean allowSelfManagement;

    private UserProfile(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
        this.name = builder.name;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
        this.allowSelfManagement = builder.allowSelfManagement;
    }

    public final String iamUserArn() {
        return this.iamUserArn;
    }

    public final String name() {
        return this.name;
    }

    public final String sshUsername() {
        return this.sshUsername;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    public final Boolean allowSelfManagement() {
        return this.allowSelfManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSelfManagement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProfile)) {
            return false;
        }
        UserProfile other = (UserProfile)obj;
        return Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sshUsername(), other.sshUsername()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.allowSelfManagement(), other.allowSelfManagement());
    }

    public final String toString() {
        return ToString.builder((String)"UserProfile").add("IamUserArn", (Object)this.iamUserArn()).add("Name", (Object)this.name()).add("SshUsername", (Object)this.sshUsername()).add("SshPublicKey", (Object)this.sshPublicKey()).add("AllowSelfManagement", (Object)this.allowSelfManagement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SshUsername": {
                return Optional.ofNullable(clazz.cast(this.sshUsername()));
            }
            case "SshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "AllowSelfManagement": {
                return Optional.ofNullable(clazz.cast(this.allowSelfManagement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IamUserArn", IAM_USER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("SshUsername", SSH_USERNAME_FIELD);
        map.put("SshPublicKey", SSH_PUBLIC_KEY_FIELD);
        map.put("AllowSelfManagement", ALLOW_SELF_MANAGEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserProfile, T> g) {
        return obj -> g.apply((UserProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String iamUserArn;
        private String name;
        private String sshUsername;
        private String sshPublicKey;
        private Boolean allowSelfManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(UserProfile model) {
            this.iamUserArn(model.iamUserArn);
            this.name(model.name);
            this.sshUsername(model.sshUsername);
            this.sshPublicKey(model.sshPublicKey);
            this.allowSelfManagement(model.allowSelfManagement);
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSshUsername() {
            return this.sshUsername;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final Boolean getAllowSelfManagement() {
            return this.allowSelfManagement;
        }

        public final void setAllowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
        }

        @Override
        public final Builder allowSelfManagement(Boolean allowSelfManagement) {
            this.allowSelfManagement = allowSelfManagement;
            return this;
        }

        public UserProfile build() {
            return new UserProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserProfile> {
        public Builder iamUserArn(String var1);

        public Builder name(String var1);

        public Builder sshUsername(String var1);

        public Builder sshPublicKey(String var1);

        public Builder allowSelfManagement(Boolean var1);
    }
}

