/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.Backup;
import software.amazon.awssdk.services.opsworkscm.model.BackupsCopier;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupsResponse
extends OpsWorksCmResponse
implements ToCopyableBuilder<Builder, DescribeBackupsResponse> {
    private static final SdkField<List<Backup>> BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Backups").getter(DescribeBackupsResponse.getter(DescribeBackupsResponse::backups)).setter(DescribeBackupsResponse.setter(Builder::backups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Backup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBackupsResponse.getter(DescribeBackupsResponse::nextToken)).setter(DescribeBackupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBackupsResponse.memberNameToFieldInitializer();
    private final List<Backup> backups;
    private final String nextToken;

    private DescribeBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.backups = builder.backups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBackups() {
        return this.backups != null && !(this.backups instanceof SdkAutoConstructList);
    }

    public final List<Backup> backups() {
        return this.backups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackups() ? this.backups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsResponse)) {
            return false;
        }
        DescribeBackupsResponse other = (DescribeBackupsResponse)((Object)obj);
        return this.hasBackups() == other.hasBackups() && Objects.equals(this.backups(), other.backups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBackupsResponse").add("Backups", this.hasBackups() ? this.backups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Backups": {
                return Optional.ofNullable(clazz.cast(this.backups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Backups", BACKUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupsResponse, T> g) {
        return obj -> g.apply((DescribeBackupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmResponse.BuilderImpl
    implements Builder {
        private List<Backup> backups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsResponse model) {
            super(model);
            this.backups(model.backups);
            this.nextToken(model.nextToken);
        }

        public final List<Backup.Builder> getBackups() {
            List<Backup.Builder> result = BackupsCopier.copyToBuilder(this.backups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackups(Collection<Backup.BuilderImpl> backups) {
            this.backups = BackupsCopier.copyFromBuilder(backups);
        }

        @Override
        public final Builder backups(Collection<Backup> backups) {
            this.backups = BackupsCopier.copy(backups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backups(Backup ... backups) {
            this.backups(Arrays.asList(backups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backups(Consumer<Backup.Builder> ... backups) {
            this.backups(Stream.of(backups).map(c -> (Backup)((Backup.Builder)Backup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeBackupsResponse build() {
            return new DescribeBackupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpsWorksCmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupsResponse> {
        public Builder backups(Collection<Backup> var1);

        public Builder backups(Backup ... var1);

        public Builder backups(Consumer<Backup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

