/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CIDRListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionDetails> {
    private static final SdkField<String> CLIENT_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientPublicKey").getter(ConnectionDetails.getter(ConnectionDetails::clientPublicKey)).setter(ConnectionDetails.setter(Builder::clientPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPublicKey").build()}).build();
    private static final SdkField<String> SERVER_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerPublicKey").getter(ConnectionDetails.getter(ConnectionDetails::serverPublicKey)).setter(ConnectionDetails.setter(Builder::serverPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerPublicKey").build()}).build();
    private static final SdkField<String> SERVER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerEndpoint").getter(ConnectionDetails.getter(ConnectionDetails::serverEndpoint)).setter(ConnectionDetails.setter(Builder::serverEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerEndpoint").build()}).build();
    private static final SdkField<String> CLIENT_TUNNEL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientTunnelAddress").getter(ConnectionDetails.getter(ConnectionDetails::clientTunnelAddress)).setter(ConnectionDetails.setter(Builder::clientTunnelAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientTunnelAddress").build()}).build();
    private static final SdkField<String> SERVER_TUNNEL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerTunnelAddress").getter(ConnectionDetails.getter(ConnectionDetails::serverTunnelAddress)).setter(ConnectionDetails.setter(Builder::serverTunnelAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTunnelAddress").build()}).build();
    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedIps").getter(ConnectionDetails.getter(ConnectionDetails::allowedIps)).setter(ConnectionDetails.setter(Builder::allowedIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_PUBLIC_KEY_FIELD, SERVER_PUBLIC_KEY_FIELD, SERVER_ENDPOINT_FIELD, CLIENT_TUNNEL_ADDRESS_FIELD, SERVER_TUNNEL_ADDRESS_FIELD, ALLOWED_IPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectionDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientPublicKey;
    private final String serverPublicKey;
    private final String serverEndpoint;
    private final String clientTunnelAddress;
    private final String serverTunnelAddress;
    private final List<String> allowedIps;

    private ConnectionDetails(BuilderImpl builder) {
        this.clientPublicKey = builder.clientPublicKey;
        this.serverPublicKey = builder.serverPublicKey;
        this.serverEndpoint = builder.serverEndpoint;
        this.clientTunnelAddress = builder.clientTunnelAddress;
        this.serverTunnelAddress = builder.serverTunnelAddress;
        this.allowedIps = builder.allowedIps;
    }

    public final String clientPublicKey() {
        return this.clientPublicKey;
    }

    public final String serverPublicKey() {
        return this.serverPublicKey;
    }

    public final String serverEndpoint() {
        return this.serverEndpoint;
    }

    public final String clientTunnelAddress() {
        return this.clientTunnelAddress;
    }

    public final String serverTunnelAddress() {
        return this.serverTunnelAddress;
    }

    public final boolean hasAllowedIps() {
        return this.allowedIps != null && !(this.allowedIps instanceof SdkAutoConstructList);
    }

    public final List<String> allowedIps() {
        return this.allowedIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientTunnelAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTunnelAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedIps() ? this.allowedIps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionDetails)) {
            return false;
        }
        ConnectionDetails other = (ConnectionDetails)obj;
        return Objects.equals(this.clientPublicKey(), other.clientPublicKey()) && Objects.equals(this.serverPublicKey(), other.serverPublicKey()) && Objects.equals(this.serverEndpoint(), other.serverEndpoint()) && Objects.equals(this.clientTunnelAddress(), other.clientTunnelAddress()) && Objects.equals(this.serverTunnelAddress(), other.serverTunnelAddress()) && this.hasAllowedIps() == other.hasAllowedIps() && Objects.equals(this.allowedIps(), other.allowedIps());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionDetails").add("ClientPublicKey", (Object)this.clientPublicKey()).add("ServerPublicKey", (Object)this.serverPublicKey()).add("ServerEndpoint", (Object)this.serverEndpoint()).add("ClientTunnelAddress", (Object)this.clientTunnelAddress()).add("ServerTunnelAddress", (Object)this.serverTunnelAddress()).add("AllowedIps", this.hasAllowedIps() ? this.allowedIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientPublicKey": {
                return Optional.ofNullable(clazz.cast(this.clientPublicKey()));
            }
            case "ServerPublicKey": {
                return Optional.ofNullable(clazz.cast(this.serverPublicKey()));
            }
            case "ServerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.serverEndpoint()));
            }
            case "ClientTunnelAddress": {
                return Optional.ofNullable(clazz.cast(this.clientTunnelAddress()));
            }
            case "ServerTunnelAddress": {
                return Optional.ofNullable(clazz.cast(this.serverTunnelAddress()));
            }
            case "AllowedIps": {
                return Optional.ofNullable(clazz.cast(this.allowedIps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientPublicKey", CLIENT_PUBLIC_KEY_FIELD);
        map.put("ServerPublicKey", SERVER_PUBLIC_KEY_FIELD);
        map.put("ServerEndpoint", SERVER_ENDPOINT_FIELD);
        map.put("ClientTunnelAddress", CLIENT_TUNNEL_ADDRESS_FIELD);
        map.put("ServerTunnelAddress", SERVER_TUNNEL_ADDRESS_FIELD);
        map.put("AllowedIps", ALLOWED_IPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionDetails, T> g) {
        return obj -> g.apply((ConnectionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientPublicKey;
        private String serverPublicKey;
        private String serverEndpoint;
        private String clientTunnelAddress;
        private String serverTunnelAddress;
        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionDetails model) {
            this.clientPublicKey(model.clientPublicKey);
            this.serverPublicKey(model.serverPublicKey);
            this.serverEndpoint(model.serverEndpoint);
            this.clientTunnelAddress(model.clientTunnelAddress);
            this.serverTunnelAddress(model.serverTunnelAddress);
            this.allowedIps(model.allowedIps);
        }

        public final String getClientPublicKey() {
            return this.clientPublicKey;
        }

        public final void setClientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
        }

        @Override
        public final Builder clientPublicKey(String clientPublicKey) {
            this.clientPublicKey = clientPublicKey;
            return this;
        }

        public final String getServerPublicKey() {
            return this.serverPublicKey;
        }

        public final void setServerPublicKey(String serverPublicKey) {
            this.serverPublicKey = serverPublicKey;
        }

        @Override
        public final Builder serverPublicKey(String serverPublicKey) {
            this.serverPublicKey = serverPublicKey;
            return this;
        }

        public final String getServerEndpoint() {
            return this.serverEndpoint;
        }

        public final void setServerEndpoint(String serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
        }

        @Override
        public final Builder serverEndpoint(String serverEndpoint) {
            this.serverEndpoint = serverEndpoint;
            return this;
        }

        public final String getClientTunnelAddress() {
            return this.clientTunnelAddress;
        }

        public final void setClientTunnelAddress(String clientTunnelAddress) {
            this.clientTunnelAddress = clientTunnelAddress;
        }

        @Override
        public final Builder clientTunnelAddress(String clientTunnelAddress) {
            this.clientTunnelAddress = clientTunnelAddress;
            return this;
        }

        public final String getServerTunnelAddress() {
            return this.serverTunnelAddress;
        }

        public final void setServerTunnelAddress(String serverTunnelAddress) {
            this.serverTunnelAddress = serverTunnelAddress;
        }

        @Override
        public final Builder serverTunnelAddress(String serverTunnelAddress) {
            this.serverTunnelAddress = serverTunnelAddress;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (this.allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = CIDRListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = CIDRListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String ... allowedIps) {
            this.allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        public ConnectionDetails build() {
            return new ConnectionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionDetails> {
        public Builder clientPublicKey(String var1);

        public Builder serverPublicKey(String var1);

        public Builder serverEndpoint(String var1);

        public Builder clientTunnelAddress(String var1);

        public Builder serverTunnelAddress(String var1);

        public Builder allowedIps(Collection<String> var1);

        public Builder allowedIps(String ... var1);
    }
}

