/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParticipantType {
    SENDER("SENDER"),
    RECEIVER("RECEIVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParticipantType> VALUE_MAP;
    private final String value;

    private ParticipantType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParticipantType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParticipantType> knownValues() {
        EnumSet<ParticipantType> knownValues = EnumSet.allOf(ParticipantType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParticipantType.class, ParticipantType::toString);
    }
}

