/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReviewStatus {
    PENDING_SUBMISSION("Pending Submission"),
    SUBMITTED("Submitted"),
    IN_REVIEW("In review"),
    APPROVED("Approved"),
    REJECTED("Rejected"),
    ACTION_REQUIRED("Action Required"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReviewStatus> VALUE_MAP;
    private final String value;

    private ReviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReviewStatus> knownValues() {
        EnumSet<ReviewStatus> knownValues = EnumSet.allOf(ReviewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReviewStatus.class, ReviewStatus::toString);
    }
}

