/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.partnercentralselling.PartnerCentralSellingClient;
import software.amazon.awssdk.services.partnercentralselling.internal.UserAgentUtils;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementInvitationSummary;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;

public class ListEngagementInvitationsIterable
implements SdkIterable<ListEngagementInvitationsResponse> {
    private final PartnerCentralSellingClient client;
    private final ListEngagementInvitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEngagementInvitationsIterable(PartnerCentralSellingClient client, ListEngagementInvitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEngagementInvitationsResponseFetcher();
    }

    public Iterator<ListEngagementInvitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EngagementInvitationSummary> engagementInvitationSummaries() {
        Function<ListEngagementInvitationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.engagementInvitationSummaries() != null) {
                return response.engagementInvitationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEngagementInvitationsResponseFetcher
    implements SyncPageFetcher<ListEngagementInvitationsResponse> {
        private ListEngagementInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEngagementInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEngagementInvitationsResponse nextPage(ListEngagementInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListEngagementInvitationsIterable.this.client.listEngagementInvitations(ListEngagementInvitationsIterable.this.firstRequest);
            }
            return ListEngagementInvitationsIterable.this.client.listEngagementInvitations((ListEngagementInvitationsRequest)((Object)ListEngagementInvitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

