/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recipe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Recipe.getter(Recipe::name)).setter(Recipe.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeArn").getter(Recipe.getter(Recipe::recipeArn)).setter(Recipe.setter(Builder::recipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeArn").build()}).build();
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("algorithmArn").getter(Recipe.getter(Recipe::algorithmArn)).setter(Recipe.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmArn").build()}).build();
    private static final SdkField<String> FEATURE_TRANSFORMATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featureTransformationArn").getter(Recipe.getter(Recipe::featureTransformationArn)).setter(Recipe.setter(Builder::featureTransformationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureTransformationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Recipe.getter(Recipe::status)).setter(Recipe.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Recipe.getter(Recipe::description)).setter(Recipe.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(Recipe.getter(Recipe::creationDateTime)).setter(Recipe.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> RECIPE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recipeType").getter(Recipe.getter(Recipe::recipeType)).setter(Recipe.setter(Builder::recipeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipeType").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(Recipe.getter(Recipe::lastUpdatedDateTime)).setter(Recipe.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RECIPE_ARN_FIELD, ALGORITHM_ARN_FIELD, FEATURE_TRANSFORMATION_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATION_DATE_TIME_FIELD, RECIPE_TYPE_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recipe.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String recipeArn;
    private final String algorithmArn;
    private final String featureTransformationArn;
    private final String status;
    private final String description;
    private final Instant creationDateTime;
    private final String recipeType;
    private final Instant lastUpdatedDateTime;

    private Recipe(BuilderImpl builder) {
        this.name = builder.name;
        this.recipeArn = builder.recipeArn;
        this.algorithmArn = builder.algorithmArn;
        this.featureTransformationArn = builder.featureTransformationArn;
        this.status = builder.status;
        this.description = builder.description;
        this.creationDateTime = builder.creationDateTime;
        this.recipeType = builder.recipeType;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String name() {
        return this.name;
    }

    public final String recipeArn() {
        return this.recipeArn;
    }

    public final String algorithmArn() {
        return this.algorithmArn;
    }

    public final String featureTransformationArn() {
        return this.featureTransformationArn;
    }

    public final String status() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final String recipeType() {
        return this.recipeType;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureTransformationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.recipeArn(), other.recipeArn()) && Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.featureTransformationArn(), other.featureTransformationArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.recipeType(), other.recipeType()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"Recipe").add("Name", (Object)this.name()).add("RecipeArn", (Object)this.recipeArn()).add("AlgorithmArn", (Object)this.algorithmArn()).add("FeatureTransformationArn", (Object)this.featureTransformationArn()).add("Status", (Object)this.status()).add("Description", (Object)this.description()).add("CreationDateTime", (Object)this.creationDateTime()).add("RecipeType", (Object)this.recipeType()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recipeArn": {
                return Optional.ofNullable(clazz.cast(this.recipeArn()));
            }
            case "algorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "featureTransformationArn": {
                return Optional.ofNullable(clazz.cast(this.featureTransformationArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "recipeType": {
                return Optional.ofNullable(clazz.cast(this.recipeType()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("recipeArn", RECIPE_ARN_FIELD);
        map.put("algorithmArn", ALGORITHM_ARN_FIELD);
        map.put("featureTransformationArn", FEATURE_TRANSFORMATION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("recipeType", RECIPE_TYPE_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String recipeArn;
        private String algorithmArn;
        private String featureTransformationArn;
        private String status;
        private String description;
        private Instant creationDateTime;
        private String recipeType;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            this.name(model.name);
            this.recipeArn(model.recipeArn);
            this.algorithmArn(model.algorithmArn);
            this.featureTransformationArn(model.featureTransformationArn);
            this.status(model.status);
            this.description(model.description);
            this.creationDateTime(model.creationDateTime);
            this.recipeType(model.recipeType);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeArn() {
            return this.recipeArn;
        }

        public final void setRecipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
        }

        @Override
        public final Builder recipeArn(String recipeArn) {
            this.recipeArn = recipeArn;
            return this;
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getFeatureTransformationArn() {
            return this.featureTransformationArn;
        }

        public final void setFeatureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
        }

        @Override
        public final Builder featureTransformationArn(String featureTransformationArn) {
            this.featureTransformationArn = featureTransformationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getRecipeType() {
            return this.recipeType;
        }

        public final void setRecipeType(String recipeType) {
            this.recipeType = recipeType;
        }

        @Override
        public final Builder recipeType(String recipeType) {
            this.recipeType = recipeType;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public Recipe build() {
            return new Recipe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recipe> {
        public Builder name(String var1);

        public Builder recipeArn(String var1);

        public Builder algorithmArn(String var1);

        public Builder featureTransformationArn(String var1);

        public Builder status(String var1);

        public Builder description(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder recipeType(String var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

