/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.ListRecommendersRequest;
import software.amazon.awssdk.services.personalize.model.ListRecommendersResponse;
import software.amazon.awssdk.services.personalize.model.RecommenderSummary;

public class ListRecommendersIterable
implements SdkIterable<ListRecommendersResponse> {
    private final PersonalizeClient client;
    private final ListRecommendersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendersIterable(PersonalizeClient client, ListRecommendersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendersResponseFetcher();
    }

    public Iterator<ListRecommendersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommenderSummary> recommenders() {
        Function<ListRecommendersResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommenders() != null) {
                return response.recommenders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendersResponseFetcher
    implements SyncPageFetcher<ListRecommendersResponse> {
        private ListRecommendersResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendersResponse nextPage(ListRecommendersResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendersIterable.this.client.listRecommenders(ListRecommendersIterable.this.firstRequest);
            }
            return ListRecommendersIterable.this.client.listRecommenders((ListRecommendersRequest)((Object)ListRecommendersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

