/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIAgentConfiguration;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAiAgentRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateAiAgentRequest> {
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentId").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::aiAgentId)).setter(UpdateAiAgentRequest.setter(Builder::aiAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiAgentId").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::assistantId)).setter(UpdateAiAgentRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::clientToken)).setter(UpdateAiAgentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AIAgentConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::configuration)).setter(UpdateAiAgentRequest.setter(Builder::configuration)).constructor(AIAgentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::description)).setter(UpdateAiAgentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(UpdateAiAgentRequest.getter(UpdateAiAgentRequest::visibilityStatusAsString)).setter(UpdateAiAgentRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_AGENT_ID_FIELD, ASSISTANT_ID_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, VISIBILITY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAiAgentRequest.memberNameToFieldInitializer();
    private final String aiAgentId;
    private final String assistantId;
    private final String clientToken;
    private final AIAgentConfiguration configuration;
    private final String description;
    private final String visibilityStatus;

    private UpdateAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.aiAgentId = builder.aiAgentId;
        this.assistantId = builder.assistantId;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.visibilityStatus = builder.visibilityStatus;
    }

    public final String aiAgentId() {
        return this.aiAgentId;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AIAgentConfiguration configuration() {
        return this.configuration;
    }

    public final String description() {
        return this.description;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiAgentRequest)) {
            return false;
        }
        UpdateAiAgentRequest other = (UpdateAiAgentRequest)((Object)obj);
        return Objects.equals(this.aiAgentId(), other.aiAgentId()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAiAgentRequest").add("AiAgentId", (Object)this.aiAgentId()).add("AssistantId", (Object)this.assistantId()).add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).add("Description", (Object)this.description()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aiAgentId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentId()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiAgentRequest, T> g) {
        return obj -> g.apply((UpdateAiAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String aiAgentId;
        private String assistantId;
        private String clientToken;
        private AIAgentConfiguration configuration;
        private String description;
        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiAgentRequest model) {
            super(model);
            this.aiAgentId(model.aiAgentId);
            this.assistantId(model.assistantId);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
            this.description(model.description);
            this.visibilityStatus(model.visibilityStatus);
        }

        public final String getAiAgentId() {
            return this.aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AIAgentConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AIAgentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AIAgentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiAgentRequest build() {
            return new UpdateAiAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAiAgentRequest> {
        public Builder aiAgentId(String var1);

        public Builder assistantId(String var1);

        public Builder clientToken(String var1);

        public Builder configuration(AIAgentConfiguration var1);

        default public Builder configuration(Consumer<AIAgentConfiguration.Builder> configuration) {
            return this.configuration((AIAgentConfiguration)((AIAgentConfiguration.Builder)AIAgentConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

