/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ChannelsCopier;
import software.amazon.awssdk.services.qconnect.model.GroupingConfiguration;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.QuickResponseDataProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQuickResponseRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateQuickResponseRequest> {
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channels").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::channels)).setter(UpdateQuickResponseRequest.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<QuickResponseDataProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::content)).setter(UpdateQuickResponseRequest.setter(Builder::content)).constructor(QuickResponseDataProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::contentType)).setter(UpdateQuickResponseRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::description)).setter(UpdateQuickResponseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("groupingConfiguration").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::groupingConfiguration)).setter(UpdateQuickResponseRequest.setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::isActive)).setter(UpdateQuickResponseRequest.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::knowledgeBaseId)).setter(UpdateQuickResponseRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::language)).setter(UpdateQuickResponseRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::name)).setter(UpdateQuickResponseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> QUICK_RESPONSE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quickResponseId").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::quickResponseId)).setter(UpdateQuickResponseRequest.setter(Builder::quickResponseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("quickResponseId").build()}).build();
    private static final SdkField<Boolean> REMOVE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeDescription").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::removeDescription)).setter(UpdateQuickResponseRequest.setter(Builder::removeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeDescription").build()}).build();
    private static final SdkField<Boolean> REMOVE_GROUPING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeGroupingConfiguration").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::removeGroupingConfiguration)).setter(UpdateQuickResponseRequest.setter(Builder::removeGroupingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeGroupingConfiguration").build()}).build();
    private static final SdkField<Boolean> REMOVE_SHORTCUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("removeShortcutKey").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::removeShortcutKey)).setter(UpdateQuickResponseRequest.setter(Builder::removeShortcutKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeShortcutKey").build()}).build();
    private static final SdkField<String> SHORTCUT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shortcutKey").getter(UpdateQuickResponseRequest.getter(UpdateQuickResponseRequest::shortcutKey)).setter(UpdateQuickResponseRequest.setter(Builder::shortcutKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortcutKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, DESCRIPTION_FIELD, GROUPING_CONFIGURATION_FIELD, IS_ACTIVE_FIELD, KNOWLEDGE_BASE_ID_FIELD, LANGUAGE_FIELD, NAME_FIELD, QUICK_RESPONSE_ID_FIELD, REMOVE_DESCRIPTION_FIELD, REMOVE_GROUPING_CONFIGURATION_FIELD, REMOVE_SHORTCUT_KEY_FIELD, SHORTCUT_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQuickResponseRequest.memberNameToFieldInitializer();
    private final List<String> channels;
    private final QuickResponseDataProvider content;
    private final String contentType;
    private final String description;
    private final GroupingConfiguration groupingConfiguration;
    private final Boolean isActive;
    private final String knowledgeBaseId;
    private final String language;
    private final String name;
    private final String quickResponseId;
    private final Boolean removeDescription;
    private final Boolean removeGroupingConfiguration;
    private final Boolean removeShortcutKey;
    private final String shortcutKey;

    private UpdateQuickResponseRequest(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.isActive = builder.isActive;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.language = builder.language;
        this.name = builder.name;
        this.quickResponseId = builder.quickResponseId;
        this.removeDescription = builder.removeDescription;
        this.removeGroupingConfiguration = builder.removeGroupingConfiguration;
        this.removeShortcutKey = builder.removeShortcutKey;
        this.shortcutKey = builder.shortcutKey;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channels() {
        return this.channels;
    }

    public final QuickResponseDataProvider content() {
        return this.content;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String description() {
        return this.description;
    }

    public final GroupingConfiguration groupingConfiguration() {
        return this.groupingConfiguration;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String language() {
        return this.language;
    }

    public final String name() {
        return this.name;
    }

    public final String quickResponseId() {
        return this.quickResponseId;
    }

    public final Boolean removeDescription() {
        return this.removeDescription;
    }

    public final Boolean removeGroupingConfiguration() {
        return this.removeGroupingConfiguration;
    }

    public final Boolean removeShortcutKey() {
        return this.removeShortcutKey;
    }

    public final String shortcutKey() {
        return this.shortcutKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeGroupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeShortcutKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortcutKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickResponseRequest)) {
            return false;
        }
        UpdateQuickResponseRequest other = (UpdateQuickResponseRequest)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.groupingConfiguration(), other.groupingConfiguration()) && Objects.equals(this.isActive(), other.isActive()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.quickResponseId(), other.quickResponseId()) && Objects.equals(this.removeDescription(), other.removeDescription()) && Objects.equals(this.removeGroupingConfiguration(), other.removeGroupingConfiguration()) && Objects.equals(this.removeShortcutKey(), other.removeShortcutKey()) && Objects.equals(this.shortcutKey(), other.shortcutKey());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQuickResponseRequest").add("Channels", (Object)(this.channels() == null ? null : "*** Sensitive Data Redacted ***")).add("Content", (Object)this.content()).add("ContentType", (Object)this.contentType()).add("Description", (Object)this.description()).add("GroupingConfiguration", (Object)this.groupingConfiguration()).add("IsActive", (Object)this.isActive()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Language", (Object)this.language()).add("Name", (Object)this.name()).add("QuickResponseId", (Object)this.quickResponseId()).add("RemoveDescription", (Object)this.removeDescription()).add("RemoveGroupingConfiguration", (Object)this.removeGroupingConfiguration()).add("RemoveShortcutKey", (Object)this.removeShortcutKey()).add("ShortcutKey", (Object)this.shortcutKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.groupingConfiguration()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "quickResponseId": {
                return Optional.ofNullable(clazz.cast(this.quickResponseId()));
            }
            case "removeDescription": {
                return Optional.ofNullable(clazz.cast(this.removeDescription()));
            }
            case "removeGroupingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.removeGroupingConfiguration()));
            }
            case "removeShortcutKey": {
                return Optional.ofNullable(clazz.cast(this.removeShortcutKey()));
            }
            case "shortcutKey": {
                return Optional.ofNullable(clazz.cast(this.shortcutKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channels", CHANNELS_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("quickResponseId", QUICK_RESPONSE_ID_FIELD);
        map.put("removeDescription", REMOVE_DESCRIPTION_FIELD);
        map.put("removeGroupingConfiguration", REMOVE_GROUPING_CONFIGURATION_FIELD);
        map.put("removeShortcutKey", REMOVE_SHORTCUT_KEY_FIELD);
        map.put("shortcutKey", SHORTCUT_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickResponseRequest, T> g) {
        return obj -> g.apply((UpdateQuickResponseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private QuickResponseDataProvider content;
        private String contentType;
        private String description;
        private GroupingConfiguration groupingConfiguration;
        private Boolean isActive;
        private String knowledgeBaseId;
        private String language;
        private String name;
        private String quickResponseId;
        private Boolean removeDescription;
        private Boolean removeGroupingConfiguration;
        private Boolean removeShortcutKey;
        private String shortcutKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickResponseRequest model) {
            super(model);
            this.channels(model.channels);
            this.content(model.content);
            this.contentType(model.contentType);
            this.description(model.description);
            this.groupingConfiguration(model.groupingConfiguration);
            this.isActive(model.isActive);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.language(model.language);
            this.name(model.name);
            this.quickResponseId(model.quickResponseId);
            this.removeDescription(model.removeDescription);
            this.removeGroupingConfiguration(model.removeGroupingConfiguration);
            this.removeShortcutKey(model.removeShortcutKey);
            this.shortcutKey(model.shortcutKey);
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final QuickResponseDataProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(QuickResponseDataProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(QuickResponseDataProvider content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return this.groupingConfiguration != null ? this.groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQuickResponseId() {
            return this.quickResponseId;
        }

        public final void setQuickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
        }

        @Override
        public final Builder quickResponseId(String quickResponseId) {
            this.quickResponseId = quickResponseId;
            return this;
        }

        public final Boolean getRemoveDescription() {
            return this.removeDescription;
        }

        public final void setRemoveDescription(Boolean removeDescription) {
            this.removeDescription = removeDescription;
        }

        @Override
        public final Builder removeDescription(Boolean removeDescription) {
            this.removeDescription = removeDescription;
            return this;
        }

        public final Boolean getRemoveGroupingConfiguration() {
            return this.removeGroupingConfiguration;
        }

        public final void setRemoveGroupingConfiguration(Boolean removeGroupingConfiguration) {
            this.removeGroupingConfiguration = removeGroupingConfiguration;
        }

        @Override
        public final Builder removeGroupingConfiguration(Boolean removeGroupingConfiguration) {
            this.removeGroupingConfiguration = removeGroupingConfiguration;
            return this;
        }

        public final Boolean getRemoveShortcutKey() {
            return this.removeShortcutKey;
        }

        public final void setRemoveShortcutKey(Boolean removeShortcutKey) {
            this.removeShortcutKey = removeShortcutKey;
        }

        @Override
        public final Builder removeShortcutKey(Boolean removeShortcutKey) {
            this.removeShortcutKey = removeShortcutKey;
            return this;
        }

        public final String getShortcutKey() {
            return this.shortcutKey;
        }

        public final void setShortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
        }

        @Override
        public final Builder shortcutKey(String shortcutKey) {
            this.shortcutKey = shortcutKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickResponseRequest build() {
            return new UpdateQuickResponseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQuickResponseRequest> {
        public Builder channels(Collection<String> var1);

        public Builder channels(String ... var1);

        public Builder content(QuickResponseDataProvider var1);

        default public Builder content(Consumer<QuickResponseDataProvider.Builder> content) {
            return this.content((QuickResponseDataProvider)((QuickResponseDataProvider.Builder)QuickResponseDataProvider.builder().applyMutation(content)).build());
        }

        public Builder contentType(String var1);

        public Builder description(String var1);

        public Builder groupingConfiguration(GroupingConfiguration var1);

        default public Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return this.groupingConfiguration((GroupingConfiguration)((GroupingConfiguration.Builder)GroupingConfiguration.builder().applyMutation(groupingConfiguration)).build());
        }

        public Builder isActive(Boolean var1);

        public Builder knowledgeBaseId(String var1);

        public Builder language(String var1);

        public Builder name(String var1);

        public Builder quickResponseId(String var1);

        public Builder removeDescription(Boolean var1);

        public Builder removeGroupingConfiguration(Boolean var1);

        public Builder removeShortcutKey(Boolean var1);

        public Builder shortcutKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

